/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayconfiguration;

import com.adyen.model.marketpayconfiguration.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"eventTypes", "notificationId"})
public class TestNotificationConfigurationRequest {
    public static final String JSON_PROPERTY_EVENT_TYPES = "eventTypes";
    private List<EventTypesEnum> eventTypes = null;
    public static final String JSON_PROPERTY_NOTIFICATION_ID = "notificationId";
    private Long notificationId;

    public TestNotificationConfigurationRequest eventTypes(List<EventTypesEnum> eventTypes) {
        this.eventTypes = eventTypes;
        return this;
    }

    public TestNotificationConfigurationRequest addEventTypesItem(EventTypesEnum eventTypesItem) {
        if (this.eventTypes == null) {
            this.eventTypes = new ArrayList<EventTypesEnum>();
        }
        this.eventTypes.add(eventTypesItem);
        return this;
    }

    @ApiModelProperty(value="The event types to test.  If left blank, then all of the configured event types will be tested. >Permitted values: `ACCOUNT_HOLDER_CREATED`, `ACCOUNT_CREATED`, `ACCOUNT_UPDATED`, `ACCOUNT_HOLDER_UPDATED`, `ACCOUNT_HOLDER_STATUS_CHANGE`, `ACCOUNT_HOLDER_STORE_STATUS_CHANGE` `ACCOUNT_HOLDER_VERIFICATION`, `ACCOUNT_HOLDER_LIMIT_REACHED`, `ACCOUNT_HOLDER_PAYOUT`, `PAYMENT_FAILURE`, `SCHEDULED_REFUNDS`, `REPORT_AVAILABLE`, `TRANSFER_FUNDS`, `BENEFICIARY_SETUP`, `COMPENSATE_NEGATIVE_BALANCE`.")
    @JsonProperty(value="eventTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EventTypesEnum> getEventTypes() {
        return this.eventTypes;
    }

    @JsonProperty(value="eventTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventTypes(List<EventTypesEnum> eventTypes) {
        this.eventTypes = eventTypes;
    }

    public TestNotificationConfigurationRequest notificationId(Long notificationId) {
        this.notificationId = notificationId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the notification subscription configuration to be tested.")
    @JsonProperty(value="notificationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNotificationId() {
        return this.notificationId;
    }

    @JsonProperty(value="notificationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotificationId(Long notificationId) {
        this.notificationId = notificationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestNotificationConfigurationRequest testNotificationConfigurationRequest = (TestNotificationConfigurationRequest)o;
        return Objects.equals(this.eventTypes, testNotificationConfigurationRequest.eventTypes) && Objects.equals(this.notificationId, testNotificationConfigurationRequest.notificationId);
    }

    public int hashCode() {
        return Objects.hash(this.eventTypes, this.notificationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestNotificationConfigurationRequest {\n");
        sb.append("    eventTypes: ").append(this.toIndentedString(this.eventTypes)).append("\n");
        sb.append("    notificationId: ").append(this.toIndentedString(this.notificationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TestNotificationConfigurationRequest fromJson(String jsonString) throws JsonProcessingException {
        return (TestNotificationConfigurationRequest)JSON.getMapper().readValue(jsonString, TestNotificationConfigurationRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum EventTypesEnum {
        ACCOUNT_CLOSED("ACCOUNT_CLOSED"),
        ACCOUNT_CREATED("ACCOUNT_CREATED"),
        ACCOUNT_FUNDS_BELOW_THRESHOLD("ACCOUNT_FUNDS_BELOW_THRESHOLD"),
        ACCOUNT_HOLDER_CREATED("ACCOUNT_HOLDER_CREATED"),
        ACCOUNT_HOLDER_LIMIT_REACHED("ACCOUNT_HOLDER_LIMIT_REACHED"),
        ACCOUNT_HOLDER_MIGRATED("ACCOUNT_HOLDER_MIGRATED"),
        ACCOUNT_HOLDER_PAYOUT("ACCOUNT_HOLDER_PAYOUT"),
        ACCOUNT_HOLDER_STATUS_CHANGE("ACCOUNT_HOLDER_STATUS_CHANGE"),
        ACCOUNT_HOLDER_STORE_STATUS_CHANGE("ACCOUNT_HOLDER_STORE_STATUS_CHANGE"),
        ACCOUNT_HOLDER_UPCOMING_DEADLINE("ACCOUNT_HOLDER_UPCOMING_DEADLINE"),
        ACCOUNT_HOLDER_UPDATED("ACCOUNT_HOLDER_UPDATED"),
        ACCOUNT_HOLDER_VERIFICATION("ACCOUNT_HOLDER_VERIFICATION"),
        ACCOUNT_UPDATED("ACCOUNT_UPDATED"),
        BENEFICIARY_SETUP("BENEFICIARY_SETUP"),
        COMPENSATE_NEGATIVE_BALANCE("COMPENSATE_NEGATIVE_BALANCE"),
        DIRECT_DEBIT_INITIATED("DIRECT_DEBIT_INITIATED"),
        FUNDS_MIGRATED("FUNDS_MIGRATED"),
        PAYMENT_FAILURE("PAYMENT_FAILURE"),
        PENDING_CREDIT("PENDING_CREDIT"),
        REFUND_FUNDS_TRANSFER("REFUND_FUNDS_TRANSFER"),
        REPORT_AVAILABLE("REPORT_AVAILABLE"),
        SCHEDULED_REFUNDS("SCHEDULED_REFUNDS"),
        SCORE_SIGNAL_TRIGGERED("SCORE_SIGNAL_TRIGGERED"),
        TRANSFER_FUNDS("TRANSFER_FUNDS"),
        TRANSFER_NOT_PAIDOUT_TRANSFERS("TRANSFER_NOT_PAIDOUT_TRANSFERS");

        private String value;

        private EventTypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventTypesEnum fromValue(String value) {
            for (EventTypesEnum b : EventTypesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

