/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.util;

import com.adyen.model.notification.Amount;
import com.adyen.model.notification.NotificationRequestItem;
import com.adyen.util.Util;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SignatureException;
import java.util.ArrayList;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.binary.Base64;

public class HMACValidator {
    public static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";
    public static final String DATA_SEPARATOR = ":";

    public String calculateHMAC(String data, String key) throws IllegalArgumentException, SignatureException {
        try {
            if (data == null || key == null) {
                throw new IllegalArgumentException();
            }
            byte[] rawKey = DatatypeConverter.parseHexBinary((String)key);
            SecretKeySpec signingKey = new SecretKeySpec(rawKey, HMAC_SHA256_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA256_ALGORITHM);
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
            return new String(Base64.encodeBase64((byte[])rawHmac));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Missing data or key.");
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
    }

    public String calculateHMAC(NotificationRequestItem notificationRequestItem, String key) throws IllegalArgumentException, SignatureException {
        return this.calculateHMAC(this.getDataToSign(notificationRequestItem), key);
    }

    public boolean validateHMAC(String hmacSignature, String hmacKey, String payload) throws SignatureException {
        String calculatedSign = this.calculateHMAC(payload, hmacKey);
        byte[] expectedSign = calculatedSign.getBytes(StandardCharsets.UTF_8);
        byte[] merchantSign = hmacSignature.getBytes(StandardCharsets.UTF_8);
        return MessageDigest.isEqual(expectedSign, merchantSign);
    }

    public boolean validateHMAC(NotificationRequestItem notificationRequestItem, String key) throws IllegalArgumentException, SignatureException {
        if (notificationRequestItem == null) {
            throw new IllegalArgumentException("Missing NotificationRequestItem.");
        }
        if (notificationRequestItem.getAdditionalData() == null || notificationRequestItem.getAdditionalData().get("hmacSignature") == null || notificationRequestItem.getAdditionalData().get("hmacSignature").isEmpty()) {
            throw new IllegalArgumentException("Missing hmacSignature");
        }
        byte[] merchantSign = notificationRequestItem.getAdditionalData().get("hmacSignature").getBytes(StandardCharsets.UTF_8);
        byte[] expectedSign = this.calculateHMAC(notificationRequestItem, key).getBytes(StandardCharsets.UTF_8);
        return MessageDigest.isEqual(merchantSign, expectedSign);
    }

    public String getDataToSign(NotificationRequestItem notificationRequestItem) throws IllegalArgumentException {
        if (notificationRequestItem == null) {
            throw new IllegalArgumentException("Missing NotificationRequestItem.");
        }
        ArrayList<String> signedDataList = new ArrayList<String>(8);
        signedDataList.add(notificationRequestItem.getPspReference());
        signedDataList.add(notificationRequestItem.getOriginalReference());
        signedDataList.add(notificationRequestItem.getMerchantAccountCode());
        signedDataList.add(notificationRequestItem.getMerchantReference());
        Amount amount = notificationRequestItem.getAmount();
        if (amount != null && amount.getValue() != null) {
            signedDataList.add(amount.getValue().toString());
        } else {
            signedDataList.add(null);
        }
        if (amount != null && amount.getCurrency() != null) {
            signedDataList.add(amount.getCurrency());
        } else {
            signedDataList.add(null);
        }
        signedDataList.add(notificationRequestItem.getEventCode());
        signedDataList.add(String.valueOf(notificationRequestItem.isSuccess()));
        return Util.implode(DATA_SEPARATOR, signedDataList);
    }
}

