/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.balanceplatform.GetNetworkTokenResponse;
import com.adyen.model.balanceplatform.UpdateNetworkTokenRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class NetworkTokensApi
extends Service {
    public static final String API_VERSION = "2";
    protected String baseURL;

    public NetworkTokensApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    public NetworkTokensApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public GetNetworkTokenResponse getNetworkToken(String networkTokenId) throws ApiException, IOException {
        return this.getNetworkToken(networkTokenId, null);
    }

    public GetNetworkTokenResponse getNetworkToken(String networkTokenId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (networkTokenId == null) {
            throw new IllegalArgumentException("Please provide the networkTokenId path parameter");
        }
        pathParams.put("networkTokenId", networkTokenId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/networkTokens/{networkTokenId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return GetNetworkTokenResponse.fromJson(jsonResult);
    }

    public void updateNetworkToken(String networkTokenId, UpdateNetworkTokenRequest updateNetworkTokenRequest) throws ApiException, IOException {
        this.updateNetworkToken(networkTokenId, updateNetworkTokenRequest, null);
    }

    public void updateNetworkToken(String networkTokenId, UpdateNetworkTokenRequest updateNetworkTokenRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (networkTokenId == null) {
            throw new IllegalArgumentException("Please provide the networkTokenId path parameter");
        }
        pathParams.put("networkTokenId", networkTokenId);
        String requestBody = updateNetworkTokenRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/networkTokens/{networkTokenId}", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
    }
}

