/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.paymentsapp.BoardingTokenRequest;
import com.adyen.model.paymentsapp.BoardingTokenResponse;
import com.adyen.model.paymentsapp.PaymentsAppResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class PaymentsAppApi
extends Service {
    public static final String API_VERSION = "1";
    protected String baseURL;

    public PaymentsAppApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://management-live.adyen.com/v1");
    }

    public PaymentsAppApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public BoardingTokenResponse generatePaymentsAppBoardingTokenForMerchant(String merchantId, BoardingTokenRequest boardingTokenRequest) throws ApiException, IOException {
        return this.generatePaymentsAppBoardingTokenForMerchant(merchantId, boardingTokenRequest, null);
    }

    public BoardingTokenResponse generatePaymentsAppBoardingTokenForMerchant(String merchantId, BoardingTokenRequest boardingTokenRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        String requestBody = boardingTokenRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/generatePaymentsAppBoardingToken", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return BoardingTokenResponse.fromJson(jsonResult);
    }

    public BoardingTokenResponse generatePaymentsAppBoardingTokenForStore(String merchantId, String storeId, BoardingTokenRequest boardingTokenRequest) throws ApiException, IOException {
        return this.generatePaymentsAppBoardingTokenForStore(merchantId, storeId, boardingTokenRequest, null);
    }

    public BoardingTokenResponse generatePaymentsAppBoardingTokenForStore(String merchantId, String storeId, BoardingTokenRequest boardingTokenRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (storeId == null) {
            throw new IllegalArgumentException("Please provide the storeId path parameter");
        }
        pathParams.put("storeId", storeId);
        String requestBody = boardingTokenRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/stores/{storeId}/generatePaymentsAppBoardingToken", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return BoardingTokenResponse.fromJson(jsonResult);
    }

    public PaymentsAppResponse listPaymentsAppForMerchant(String merchantId) throws ApiException, IOException {
        return this.listPaymentsAppForMerchant(merchantId, null, null, null, null);
    }

    public PaymentsAppResponse listPaymentsAppForMerchant(String merchantId, String statuses, Integer limit, Long offset, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (statuses != null) {
            queryParams.put("statuses", statuses);
        }
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/paymentsApps", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return PaymentsAppResponse.fromJson(jsonResult);
    }

    public PaymentsAppResponse listPaymentsAppForStore(String merchantId, String storeId) throws ApiException, IOException {
        return this.listPaymentsAppForStore(merchantId, storeId, null, null, null, null);
    }

    public PaymentsAppResponse listPaymentsAppForStore(String merchantId, String storeId, String statuses, Integer limit, Long offset, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (storeId == null) {
            throw new IllegalArgumentException("Please provide the storeId path parameter");
        }
        pathParams.put("storeId", storeId);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (statuses != null) {
            queryParams.put("statuses", statuses);
        }
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        if (offset != null) {
            queryParams.put("offset", offset.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/stores/{storeId}/paymentsApps", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return PaymentsAppResponse.fromJson(jsonResult);
    }

    public void revokePaymentsApp(String merchantId, String installationId) throws ApiException, IOException {
        this.revokePaymentsApp(merchantId, installationId, null);
    }

    public void revokePaymentsApp(String merchantId, String installationId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (merchantId == null) {
            throw new IllegalArgumentException("Please provide the merchantId path parameter");
        }
        pathParams.put("merchantId", merchantId);
        if (installationId == null) {
            throw new IllegalArgumentException("Please provide the installationId path parameter");
        }
        pathParams.put("installationId", installationId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/merchants/{merchantId}/paymentsApps/{installationId}/revoke", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
    }
}

