/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transferwebhooks;

import com.adyen.model.transferwebhooks.JSON;
import com.adyen.model.transferwebhooks.Leg;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"legs", "ticketNumber"})
public class Airline {
    public static final String JSON_PROPERTY_LEGS = "legs";
    private List<Leg> legs = null;
    public static final String JSON_PROPERTY_TICKET_NUMBER = "ticketNumber";
    private String ticketNumber;

    public Airline legs(List<Leg> legs) {
        this.legs = legs;
        return this;
    }

    public Airline addLegsItem(Leg legsItem) {
        if (this.legs == null) {
            this.legs = new ArrayList<Leg>();
        }
        this.legs.add(legsItem);
        return this;
    }

    @ApiModelProperty(value="Details about the flight legs for this ticket.")
    @JsonProperty(value="legs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Leg> getLegs() {
        return this.legs;
    }

    @JsonProperty(value="legs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegs(List<Leg> legs) {
        this.legs = legs;
    }

    public Airline ticketNumber(String ticketNumber) {
        this.ticketNumber = ticketNumber;
        return this;
    }

    @ApiModelProperty(value="The ticket's unique identifier")
    @JsonProperty(value="ticketNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTicketNumber() {
        return this.ticketNumber;
    }

    @JsonProperty(value="ticketNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTicketNumber(String ticketNumber) {
        this.ticketNumber = ticketNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Airline airline = (Airline)o;
        return Objects.equals(this.legs, airline.legs) && Objects.equals(this.ticketNumber, airline.ticketNumber);
    }

    public int hashCode() {
        return Objects.hash(this.legs, this.ticketNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Airline {\n");
        sb.append("    legs: ").append(this.toIndentedString(this.legs)).append("\n");
        sb.append("    ticketNumber: ").append(this.toIndentedString(this.ticketNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Airline fromJson(String jsonString) throws JsonProcessingException {
        return (Airline)JSON.getMapper().readValue(jsonString, Airline.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

