/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.Amount;
import com.adyen.model.transfers.CounterpartyInfoV3;
import com.adyen.model.transfers.JSON;
import com.adyen.model.transfers.TransferRequestReview;
import com.adyen.model.transfers.UltimatePartyIdentification;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "balanceAccountId", "category", "counterparty", "description", "paymentInstrumentId", "priorities", "priority", "reference", "referenceForBeneficiary", "review", "type", "ultimateParty"})
public class TransferInfo {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_BALANCE_ACCOUNT_ID = "balanceAccountId";
    private String balanceAccountId;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private CategoryEnum category;
    public static final String JSON_PROPERTY_COUNTERPARTY = "counterparty";
    private CounterpartyInfoV3 counterparty;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT_ID = "paymentInstrumentId";
    private String paymentInstrumentId;
    public static final String JSON_PROPERTY_PRIORITIES = "priorities";
    private List<PrioritiesEnum> priorities = null;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private PriorityEnum priority;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_REFERENCE_FOR_BENEFICIARY = "referenceForBeneficiary";
    private String referenceForBeneficiary;
    public static final String JSON_PROPERTY_REVIEW = "review";
    private TransferRequestReview review;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_ULTIMATE_PARTY = "ultimateParty";
    private UltimatePartyIdentification ultimateParty;

    public TransferInfo amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public TransferInfo balanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the source [balance account](https://docs.adyen.com/api-explorer/balanceplatform/latest/post/balanceAccounts#responses-200-id).  If you want to make a transfer using a **virtual** **bankAccount** assigned to the balance account, you must specify the [payment instrument ID](https://docs.adyen.com/api-explorer/balanceplatform/latest/post/paymentInstruments#responses-200-id) of the **virtual** **bankAccount**. If you only specify a balance account ID, Adyen uses the default **physical** **bankAccount** payment instrument assigned to the balance account.")
    @JsonProperty(value="balanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalanceAccountId() {
        return this.balanceAccountId;
    }

    @JsonProperty(value="balanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
    }

    public TransferInfo category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(required=true, value="The category of the transfer.  Possible values:   - **bank**: a transfer involving a [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id) or a bank account.  - **card**: a transfer involving a third-party card.  - **internal**: a transfer between [balance accounts](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id) within your platform.  - **issuedCard**: a transfer initiated by a Adyen-issued card.  - **platformPayment**: funds movements related to payments that are acquired for your users.  - **topUp**: an incoming transfer initiated by your user to top up their balance account.")
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CategoryEnum getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public TransferInfo counterparty(CounterpartyInfoV3 counterparty) {
        this.counterparty = counterparty;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CounterpartyInfoV3 getCounterparty() {
        return this.counterparty;
    }

    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCounterparty(CounterpartyInfoV3 counterparty) {
        this.counterparty = counterparty;
    }

    public TransferInfo description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for the transfer. It is used by most banks as the transfer description. We recommend sending a maximum of 140 characters, otherwise the description may be truncated.  Supported characters: **[a-z] [A-Z] [0-9] / - ?** **: ( ) . , ' + Space**  Supported characters for **regular** and **fast** transfers to a US counterparty: **[a-z] [A-Z] [0-9] & $ % # @** **~ = + - _ ' \" ! ?**")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public TransferInfo paymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the source [payment instrument](https://docs.adyen.com/api-explorer/balanceplatform/latest/post/paymentInstruments#responses-200-id).  If you want to make a transfer using a **virtual** **bankAccount**, you must specify the payment instrument ID of the **virtual** **bankAccount**. If you only specify a balance account ID, Adyen uses the default **physical** **bankAccount** payment instrument assigned to the balance account.")
    @JsonProperty(value="paymentInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentInstrumentId() {
        return this.paymentInstrumentId;
    }

    @JsonProperty(value="paymentInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
    }

    public TransferInfo priorities(List<PrioritiesEnum> priorities) {
        this.priorities = priorities;
        return this;
    }

    public TransferInfo addPrioritiesItem(PrioritiesEnum prioritiesItem) {
        if (this.priorities == null) {
            this.priorities = new ArrayList<PrioritiesEnum>();
        }
        this.priorities.add(prioritiesItem);
        return this;
    }

    @ApiModelProperty(value=" The list of priorities for the bank transfer. This sets the speed at which the transfer is sent and the fees that you have to pay. You can provide multiple priorities. Adyen will try to pay out using the priority you list first. If that's not possible, it moves on to the next option in the order of your provided priorities.   Possible values:  * **regular**: for normal, low-value transactions.  * **fast**: a faster way to transfer funds, but the fees are higher. Recommended for high-priority, low-value transactions.  * **wire**: the fastest way to transfer funds, but this has the highest fees. Recommended for high-priority, high-value transactions.  * **instant**: for instant funds transfers in [SEPA countries](https://www.ecb.europa.eu/paym/integration/retail/sepa/html/index.en.html).  * **crossBorder**: for high-value transfers to a recipient in a different country.  * **internal**: for transfers to an Adyen-issued business bank account (by bank account number/IBAN).  Required for transfers with `category` **bank**. For more details, see [fallback priorities](https://docs.adyen.com/payouts/payout-service/payout-to-users/#fallback-priorities).")
    @JsonProperty(value="priorities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PrioritiesEnum> getPriorities() {
        return this.priorities;
    }

    @JsonProperty(value="priorities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriorities(List<PrioritiesEnum> priorities) {
        this.priorities = priorities;
    }

    public TransferInfo priority(PriorityEnum priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(value="The priority for the bank transfer. This sets the speed at which the transfer is sent and the fees that you have to pay. Required for transfers with `category` **bank**.  Possible values:  * **regular**: for normal, low-value transactions.  * **fast**: a faster way to transfer funds, but the fees are higher. Recommended for high-priority, low-value transactions.  * **wire**: the fastest way to transfer funds, but this has the highest fees. Recommended for high-priority, high-value transactions.  * **instant**: for instant funds transfers in [SEPA countries](https://www.ecb.europa.eu/paym/integration/retail/sepa/html/index.en.html).  * **crossBorder**: for high-value transfers to a recipient in a different country.  * **internal**: for transfers to an Adyen-issued business bank account (by bank account number/IBAN).")
    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PriorityEnum getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriority(PriorityEnum priority) {
        this.priority = priority;
    }

    public TransferInfo reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the transfer, used internally within your platform. If you don't provide this in the request, Adyen generates a unique reference.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public TransferInfo referenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
        return this;
    }

    @ApiModelProperty(value=" A reference that is sent to the recipient. This reference is also sent in all webhooks related to the transfer, so you can use it to track statuses for both parties involved in the funds movement.   Supported characters: **a-z**, **A-Z**, **0-9**. The maximum length depends on the `category`.  - **internal**: 80 characters  - **bank**: 35 characters when transferring to an IBAN, 15 characters for others.")
    @JsonProperty(value="referenceForBeneficiary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReferenceForBeneficiary() {
        return this.referenceForBeneficiary;
    }

    @JsonProperty(value="referenceForBeneficiary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
    }

    public TransferInfo review(TransferRequestReview review) {
        this.review = review;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="review")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransferRequestReview getReview() {
        return this.review;
    }

    @JsonProperty(value="review")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReview(TransferRequestReview review) {
        this.review = review;
    }

    public TransferInfo type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of transfer.  Possible values:   - **bankTransfer**: for push transfers to a transfer instrument or a bank account. The `category` must be **bank**. - **internalTransfer**: for push transfers between balance accounts. The `category` must be **internal**. - **internalDirectDebit**: for pull transfers (direct debits) between balance accounts. The `category` must be **internal**.   ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public TransferInfo ultimateParty(UltimatePartyIdentification ultimateParty) {
        this.ultimateParty = ultimateParty;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="ultimateParty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UltimatePartyIdentification getUltimateParty() {
        return this.ultimateParty;
    }

    @JsonProperty(value="ultimateParty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUltimateParty(UltimatePartyIdentification ultimateParty) {
        this.ultimateParty = ultimateParty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferInfo transferInfo = (TransferInfo)o;
        return Objects.equals(this.amount, transferInfo.amount) && Objects.equals(this.balanceAccountId, transferInfo.balanceAccountId) && Objects.equals((Object)this.category, (Object)transferInfo.category) && Objects.equals(this.counterparty, transferInfo.counterparty) && Objects.equals(this.description, transferInfo.description) && Objects.equals(this.paymentInstrumentId, transferInfo.paymentInstrumentId) && Objects.equals(this.priorities, transferInfo.priorities) && Objects.equals((Object)this.priority, (Object)transferInfo.priority) && Objects.equals(this.reference, transferInfo.reference) && Objects.equals(this.referenceForBeneficiary, transferInfo.referenceForBeneficiary) && Objects.equals(this.review, transferInfo.review) && Objects.equals((Object)this.type, (Object)transferInfo.type) && Objects.equals(this.ultimateParty, transferInfo.ultimateParty);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.balanceAccountId, this.category, this.counterparty, this.description, this.paymentInstrumentId, this.priorities, this.priority, this.reference, this.referenceForBeneficiary, this.review, this.type, this.ultimateParty});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferInfo {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balanceAccountId: ").append(this.toIndentedString(this.balanceAccountId)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    paymentInstrumentId: ").append(this.toIndentedString(this.paymentInstrumentId)).append("\n");
        sb.append("    priorities: ").append(this.toIndentedString(this.priorities)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString((Object)this.priority)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    referenceForBeneficiary: ").append(this.toIndentedString(this.referenceForBeneficiary)).append("\n");
        sb.append("    review: ").append(this.toIndentedString(this.review)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    ultimateParty: ").append(this.toIndentedString(this.ultimateParty)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TransferInfo fromJson(String jsonString) throws JsonProcessingException {
        return (TransferInfo)JSON.getMapper().readValue(jsonString, TransferInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        BANKTRANSFER("bankTransfer"),
        INTERNALTRANSFER("internalTransfer"),
        INTERNALDIRECTDEBIT("internalDirectDebit");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PriorityEnum {
        CROSSBORDER("crossBorder"),
        FAST("fast"),
        INSTANT("instant"),
        INTERNAL("internal"),
        REGULAR("regular"),
        WIRE("wire");

        private String value;

        private PriorityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PriorityEnum fromValue(String value) {
            for (PriorityEnum b : PriorityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PrioritiesEnum {
        CROSSBORDER("crossBorder"),
        FAST("fast"),
        INSTANT("instant"),
        INTERNAL("internal"),
        REGULAR("regular"),
        WIRE("wire");

        private String value;

        private PrioritiesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PrioritiesEnum fromValue(String value) {
            for (PrioritiesEnum b : PrioritiesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CategoryEnum {
        BANK("bank"),
        CARD("card"),
        INTERNAL("internal"),
        ISSUEDCARD("issuedCard"),
        PLATFORMPAYMENT("platformPayment"),
        TOPUP("topUp");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

