/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.recurring;

import com.adyen.model.recurring.JSON;
import com.adyen.model.recurring.Permit;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"merchantAccount", "permits", "recurringDetailReference", "shopperReference"})
public class CreatePermitRequest {
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_PERMITS = "permits";
    private List<Permit> permits = new ArrayList<Permit>();
    public static final String JSON_PROPERTY_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
    private String recurringDetailReference;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;

    public CreatePermitRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier, with which you want to process the transaction.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public CreatePermitRequest permits(List<Permit> permits) {
        this.permits = permits;
        return this;
    }

    public CreatePermitRequest addPermitsItem(Permit permitsItem) {
        this.permits.add(permitsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The permits to create for this recurring contract.")
    @JsonProperty(value="permits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Permit> getPermits() {
        return this.permits;
    }

    @JsonProperty(value="permits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPermits(List<Permit> permits) {
        this.permits = permits;
    }

    public CreatePermitRequest recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The recurring contract the new permits will use.")
    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public CreatePermitRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The shopper's reference to uniquely identify this shopper (e.g. user ID or account ID).")
    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePermitRequest createPermitRequest = (CreatePermitRequest)o;
        return Objects.equals(this.merchantAccount, createPermitRequest.merchantAccount) && Objects.equals(this.permits, createPermitRequest.permits) && Objects.equals(this.recurringDetailReference, createPermitRequest.recurringDetailReference) && Objects.equals(this.shopperReference, createPermitRequest.shopperReference);
    }

    public int hashCode() {
        return Objects.hash(this.merchantAccount, this.permits, this.recurringDetailReference, this.shopperReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreatePermitRequest {\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    permits: ").append(this.toIndentedString(this.permits)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CreatePermitRequest fromJson(String jsonString) throws JsonProcessingException {
        return (CreatePermitRequest)JSON.getMapper().readValue(jsonString, CreatePermitRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

