/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.posterminalmanagement;

import com.adyen.model.posterminalmanagement.JSON;
import com.adyen.model.posterminalmanagement.Store;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"inStoreTerminals", "inventoryTerminals", "merchantAccount", "stores"})
public class MerchantAccount {
    public static final String JSON_PROPERTY_IN_STORE_TERMINALS = "inStoreTerminals";
    private List<String> inStoreTerminals = null;
    public static final String JSON_PROPERTY_INVENTORY_TERMINALS = "inventoryTerminals";
    private List<String> inventoryTerminals = null;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_STORES = "stores";
    private List<Store> stores = null;

    public MerchantAccount inStoreTerminals(List<String> inStoreTerminals) {
        this.inStoreTerminals = inStoreTerminals;
        return this;
    }

    public MerchantAccount addInStoreTerminalsItem(String inStoreTerminalsItem) {
        if (this.inStoreTerminals == null) {
            this.inStoreTerminals = new ArrayList<String>();
        }
        this.inStoreTerminals.add(inStoreTerminalsItem);
        return this;
    }

    @ApiModelProperty(value="List of terminals assigned to this merchant account as in-store terminals. This means that the terminal is ready to be boarded, or is already boarded.")
    @JsonProperty(value="inStoreTerminals")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getInStoreTerminals() {
        return this.inStoreTerminals;
    }

    @JsonProperty(value="inStoreTerminals")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInStoreTerminals(List<String> inStoreTerminals) {
        this.inStoreTerminals = inStoreTerminals;
    }

    public MerchantAccount inventoryTerminals(List<String> inventoryTerminals) {
        this.inventoryTerminals = inventoryTerminals;
        return this;
    }

    public MerchantAccount addInventoryTerminalsItem(String inventoryTerminalsItem) {
        if (this.inventoryTerminals == null) {
            this.inventoryTerminals = new ArrayList<String>();
        }
        this.inventoryTerminals.add(inventoryTerminalsItem);
        return this;
    }

    @ApiModelProperty(value="List of terminals assigned to the inventory of this merchant account.")
    @JsonProperty(value="inventoryTerminals")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getInventoryTerminals() {
        return this.inventoryTerminals;
    }

    @JsonProperty(value="inventoryTerminals")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInventoryTerminals(List<String> inventoryTerminals) {
        this.inventoryTerminals = inventoryTerminals;
    }

    public MerchantAccount merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public MerchantAccount stores(List<Store> stores) {
        this.stores = stores;
        return this;
    }

    public MerchantAccount addStoresItem(Store storesItem) {
        if (this.stores == null) {
            this.stores = new ArrayList<Store>();
        }
        this.stores.add(storesItem);
        return this;
    }

    @ApiModelProperty(value="Array of stores under this merchant account.")
    @JsonProperty(value="stores")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Store> getStores() {
        return this.stores;
    }

    @JsonProperty(value="stores")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStores(List<Store> stores) {
        this.stores = stores;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerchantAccount merchantAccount = (MerchantAccount)o;
        return Objects.equals(this.inStoreTerminals, merchantAccount.inStoreTerminals) && Objects.equals(this.inventoryTerminals, merchantAccount.inventoryTerminals) && Objects.equals(this.merchantAccount, merchantAccount.merchantAccount) && Objects.equals(this.stores, merchantAccount.stores);
    }

    public int hashCode() {
        return Objects.hash(this.inStoreTerminals, this.inventoryTerminals, this.merchantAccount, this.stores);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerchantAccount {\n");
        sb.append("    inStoreTerminals: ").append(this.toIndentedString(this.inStoreTerminals)).append("\n");
        sb.append("    inventoryTerminals: ").append(this.toIndentedString(this.inventoryTerminals)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    stores: ").append(this.toIndentedString(this.stores)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static MerchantAccount fromJson(String jsonString) throws JsonProcessingException {
        return (MerchantAccount)JSON.getMapper().readValue(jsonString, MerchantAccount.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

