/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.posterminalmanagement;

import com.adyen.model.posterminalmanagement.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"companyAccount", "merchantAccount", "merchantInventory", "store", "terminal"})
public class FindTerminalResponse {
    public static final String JSON_PROPERTY_COMPANY_ACCOUNT = "companyAccount";
    private String companyAccount;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_MERCHANT_INVENTORY = "merchantInventory";
    private Boolean merchantInventory;
    public static final String JSON_PROPERTY_STORE = "store";
    private String store;
    public static final String JSON_PROPERTY_TERMINAL = "terminal";
    private String terminal;

    public FindTerminalResponse companyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The company account that the terminal is associated with. If this is the only account level shown in the response, the terminal is assigned to the inventory of the company account.")
    @JsonProperty(value="companyAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyAccount() {
        return this.companyAccount;
    }

    @JsonProperty(value="companyAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompanyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
    }

    public FindTerminalResponse merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(value="The merchant account that the terminal is associated with. If the response doesn't contain a `store` the terminal is assigned to this merchant account.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public FindTerminalResponse merchantInventory(Boolean merchantInventory) {
        this.merchantInventory = merchantInventory;
        return this;
    }

    @ApiModelProperty(value="Boolean that indicates if the terminal is assigned to the merchant inventory. This is returned when the terminal is assigned to a merchant account.  - If **true**, this indicates that the terminal is in the merchant inventory. This also means that the terminal cannot be boarded.  - If **false**, this indicates that the terminal is assigned to the merchant account as an in-store terminal. This means that the terminal is ready to be boarded, or is already boarded.")
    @JsonProperty(value="merchantInventory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMerchantInventory() {
        return this.merchantInventory;
    }

    @JsonProperty(value="merchantInventory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantInventory(Boolean merchantInventory) {
        this.merchantInventory = merchantInventory;
    }

    public FindTerminalResponse store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(value="The store code of the store that the terminal is assigned to.")
    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStore() {
        return this.store;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStore(String store) {
        this.store = store;
    }

    public FindTerminalResponse terminal(String terminal) {
        this.terminal = terminal;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique terminal ID.")
    @JsonProperty(value="terminal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTerminal() {
        return this.terminal;
    }

    @JsonProperty(value="terminal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTerminal(String terminal) {
        this.terminal = terminal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindTerminalResponse findTerminalResponse = (FindTerminalResponse)o;
        return Objects.equals(this.companyAccount, findTerminalResponse.companyAccount) && Objects.equals(this.merchantAccount, findTerminalResponse.merchantAccount) && Objects.equals(this.merchantInventory, findTerminalResponse.merchantInventory) && Objects.equals(this.store, findTerminalResponse.store) && Objects.equals(this.terminal, findTerminalResponse.terminal);
    }

    public int hashCode() {
        return Objects.hash(this.companyAccount, this.merchantAccount, this.merchantInventory, this.store, this.terminal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FindTerminalResponse {\n");
        sb.append("    companyAccount: ").append(this.toIndentedString(this.companyAccount)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantInventory: ").append(this.toIndentedString(this.merchantInventory)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    terminal: ").append(this.toIndentedString(this.terminal)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static FindTerminalResponse fromJson(String jsonString) throws JsonProcessingException {
        return (FindTerminalResponse)JSON.getMapper().readValue(jsonString, FindTerminalResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

