/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.paymentsapp;

import com.adyen.model.paymentsapp.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"boardingToken", "installationId"})
public class BoardingTokenResponse {
    public static final String JSON_PROPERTY_BOARDING_TOKEN = "boardingToken";
    private String boardingToken;
    public static final String JSON_PROPERTY_INSTALLATION_ID = "installationId";
    private String installationId;

    public BoardingTokenResponse boardingToken(String boardingToken) {
        this.boardingToken = boardingToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The boarding token that allows the Payments App to board.")
    @JsonProperty(value="boardingToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBoardingToken() {
        return this.boardingToken;
    }

    @JsonProperty(value="boardingToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBoardingToken(String boardingToken) {
        this.boardingToken = boardingToken;
    }

    public BoardingTokenResponse installationId(String installationId) {
        this.installationId = installationId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the Payments App instance.")
    @JsonProperty(value="installationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInstallationId() {
        return this.installationId;
    }

    @JsonProperty(value="installationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInstallationId(String installationId) {
        this.installationId = installationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoardingTokenResponse boardingTokenResponse = (BoardingTokenResponse)o;
        return Objects.equals(this.boardingToken, boardingTokenResponse.boardingToken) && Objects.equals(this.installationId, boardingTokenResponse.installationId);
    }

    public int hashCode() {
        return Objects.hash(this.boardingToken, this.installationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BoardingTokenResponse {\n");
        sb.append("    boardingToken: ").append(this.toIndentedString(this.boardingToken)).append("\n");
        sb.append("    installationId: ").append(this.toIndentedString(this.installationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static BoardingTokenResponse fromJson(String jsonString) throws JsonProcessingException {
        return (BoardingTokenResponse)JSON.getMapper().readValue(jsonString, BoardingTokenResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

