/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.ErrorFieldType;
import com.adyen.model.marketpaywebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"destinationAccountCode", "destinationAccountHolderCode", "invalidFields", "merchantReference", "sourceAccountCode", "sourceAccountHolderCode", "transferDate"})
public class BeneficiarySetupNotificationContent {
    public static final String JSON_PROPERTY_DESTINATION_ACCOUNT_CODE = "destinationAccountCode";
    private String destinationAccountCode;
    public static final String JSON_PROPERTY_DESTINATION_ACCOUNT_HOLDER_CODE = "destinationAccountHolderCode";
    private String destinationAccountHolderCode;
    public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
    private List<ErrorFieldType> invalidFields = null;
    public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
    private String merchantReference;
    public static final String JSON_PROPERTY_SOURCE_ACCOUNT_CODE = "sourceAccountCode";
    private String sourceAccountCode;
    public static final String JSON_PROPERTY_SOURCE_ACCOUNT_HOLDER_CODE = "sourceAccountHolderCode";
    private String sourceAccountHolderCode;
    public static final String JSON_PROPERTY_TRANSFER_DATE = "transferDate";
    private OffsetDateTime transferDate;

    public BeneficiarySetupNotificationContent destinationAccountCode(String destinationAccountCode) {
        this.destinationAccountCode = destinationAccountCode;
        return this;
    }

    @ApiModelProperty(value="The code of the beneficiary account.")
    @JsonProperty(value="destinationAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDestinationAccountCode() {
        return this.destinationAccountCode;
    }

    @JsonProperty(value="destinationAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestinationAccountCode(String destinationAccountCode) {
        this.destinationAccountCode = destinationAccountCode;
    }

    public BeneficiarySetupNotificationContent destinationAccountHolderCode(String destinationAccountHolderCode) {
        this.destinationAccountHolderCode = destinationAccountHolderCode;
        return this;
    }

    @ApiModelProperty(value="The code of the beneficiary Account Holder.")
    @JsonProperty(value="destinationAccountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDestinationAccountHolderCode() {
        return this.destinationAccountHolderCode;
    }

    @JsonProperty(value="destinationAccountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestinationAccountHolderCode(String destinationAccountHolderCode) {
        this.destinationAccountHolderCode = destinationAccountHolderCode;
    }

    public BeneficiarySetupNotificationContent invalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
        return this;
    }

    public BeneficiarySetupNotificationContent addInvalidFieldsItem(ErrorFieldType invalidFieldsItem) {
        if (this.invalidFields == null) {
            this.invalidFields = new ArrayList<ErrorFieldType>();
        }
        this.invalidFields.add(invalidFieldsItem);
        return this;
    }

    @ApiModelProperty(value="A listing of the invalid fields which have caused the Setup Beneficiary request to fail. If this is empty, the Setup Beneficiary request has succeeded.")
    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ErrorFieldType> getInvalidFields() {
        return this.invalidFields;
    }

    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
    }

    public BeneficiarySetupNotificationContent merchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
        return this;
    }

    @ApiModelProperty(value="The reference provided by the merchant.")
    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantReference() {
        return this.merchantReference;
    }

    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
    }

    public BeneficiarySetupNotificationContent sourceAccountCode(String sourceAccountCode) {
        this.sourceAccountCode = sourceAccountCode;
        return this;
    }

    @ApiModelProperty(value="The code of the benefactor account.")
    @JsonProperty(value="sourceAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceAccountCode() {
        return this.sourceAccountCode;
    }

    @JsonProperty(value="sourceAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceAccountCode(String sourceAccountCode) {
        this.sourceAccountCode = sourceAccountCode;
    }

    public BeneficiarySetupNotificationContent sourceAccountHolderCode(String sourceAccountHolderCode) {
        this.sourceAccountHolderCode = sourceAccountHolderCode;
        return this;
    }

    @ApiModelProperty(value="The code of the benefactor Account Holder.")
    @JsonProperty(value="sourceAccountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceAccountHolderCode() {
        return this.sourceAccountHolderCode;
    }

    @JsonProperty(value="sourceAccountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceAccountHolderCode(String sourceAccountHolderCode) {
        this.sourceAccountHolderCode = sourceAccountHolderCode;
    }

    public BeneficiarySetupNotificationContent transferDate(OffsetDateTime transferDate) {
        this.transferDate = transferDate;
        return this;
    }

    @ApiModelProperty(value="The date on which the beneficiary was set up and funds transferred from benefactor to beneficiary.")
    @JsonProperty(value="transferDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getTransferDate() {
        return this.transferDate;
    }

    @JsonProperty(value="transferDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransferDate(OffsetDateTime transferDate) {
        this.transferDate = transferDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeneficiarySetupNotificationContent beneficiarySetupNotificationContent = (BeneficiarySetupNotificationContent)o;
        return Objects.equals(this.destinationAccountCode, beneficiarySetupNotificationContent.destinationAccountCode) && Objects.equals(this.destinationAccountHolderCode, beneficiarySetupNotificationContent.destinationAccountHolderCode) && Objects.equals(this.invalidFields, beneficiarySetupNotificationContent.invalidFields) && Objects.equals(this.merchantReference, beneficiarySetupNotificationContent.merchantReference) && Objects.equals(this.sourceAccountCode, beneficiarySetupNotificationContent.sourceAccountCode) && Objects.equals(this.sourceAccountHolderCode, beneficiarySetupNotificationContent.sourceAccountHolderCode) && Objects.equals(this.transferDate, beneficiarySetupNotificationContent.transferDate);
    }

    public int hashCode() {
        return Objects.hash(this.destinationAccountCode, this.destinationAccountHolderCode, this.invalidFields, this.merchantReference, this.sourceAccountCode, this.sourceAccountHolderCode, this.transferDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BeneficiarySetupNotificationContent {\n");
        sb.append("    destinationAccountCode: ").append(this.toIndentedString(this.destinationAccountCode)).append("\n");
        sb.append("    destinationAccountHolderCode: ").append(this.toIndentedString(this.destinationAccountHolderCode)).append("\n");
        sb.append("    invalidFields: ").append(this.toIndentedString(this.invalidFields)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    sourceAccountCode: ").append(this.toIndentedString(this.sourceAccountCode)).append("\n");
        sb.append("    sourceAccountHolderCode: ").append(this.toIndentedString(this.sourceAccountHolderCode)).append("\n");
        sb.append("    transferDate: ").append(this.toIndentedString(this.transferDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static BeneficiarySetupNotificationContent fromJson(String jsonString) throws JsonProcessingException {
        return (BeneficiarySetupNotificationContent)JSON.getMapper().readValue(jsonString, BeneficiarySetupNotificationContent.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

