/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayfund;

import com.adyen.model.marketpayfund.Amount;
import com.adyen.model.marketpayfund.JSON;
import com.adyen.model.marketpayfund.Split;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderCode", "amount", "bankAccountUUID", "description", "merchantAccount", "splits"})
public class DebitAccountHolderRequest {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D = "bankAccountUUID";
    private String bankAccountUUID;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_SPLITS = "splits";
    private List<Split> splits = new ArrayList<Split>();

    public DebitAccountHolderRequest accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the account holder.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public DebitAccountHolderRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public DebitAccountHolderRequest bankAccountUUID(String bankAccountUUID) {
        this.bankAccountUUID = bankAccountUUID;
        return this;
    }

    @ApiModelProperty(required=true, value="The Adyen-generated unique alphanumeric identifier (UUID) of the account holder's bank account.")
    @JsonProperty(value="bankAccountUUID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankAccountUUID() {
        return this.bankAccountUUID;
    }

    @JsonProperty(value="bankAccountUUID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccountUUID(String bankAccountUUID) {
        this.bankAccountUUID = bankAccountUUID;
    }

    public DebitAccountHolderRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A description of the direct debit. Maximum length: 35 characters.  Allowed characters: **a-z**, **A-Z**, **0-9**, and special characters **_/?:().,'+ \";**.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public DebitAccountHolderRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="Your merchant account.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public DebitAccountHolderRequest splits(List<Split> splits) {
        this.splits = splits;
        return this;
    }

    public DebitAccountHolderRequest addSplitsItem(Split splitsItem) {
        this.splits.add(splitsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Contains instructions on how to split the funds between the accounts in your platform. The request must have at least one split item.")
    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Split> getSplits() {
        return this.splits;
    }

    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebitAccountHolderRequest debitAccountHolderRequest = (DebitAccountHolderRequest)o;
        return Objects.equals(this.accountHolderCode, debitAccountHolderRequest.accountHolderCode) && Objects.equals(this.amount, debitAccountHolderRequest.amount) && Objects.equals(this.bankAccountUUID, debitAccountHolderRequest.bankAccountUUID) && Objects.equals(this.description, debitAccountHolderRequest.description) && Objects.equals(this.merchantAccount, debitAccountHolderRequest.merchantAccount) && Objects.equals(this.splits, debitAccountHolderRequest.splits);
    }

    public int hashCode() {
        return Objects.hash(this.accountHolderCode, this.amount, this.bankAccountUUID, this.description, this.merchantAccount, this.splits);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DebitAccountHolderRequest {\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    bankAccountUUID: ").append(this.toIndentedString(this.bankAccountUUID)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DebitAccountHolderRequest fromJson(String jsonString) throws JsonProcessingException {
        return (DebitAccountHolderRequest)JSON.getMapper().readValue(jsonString, DebitAccountHolderRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

