/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderCode", "disable", "reason", "stateType"})
public class UpdateAccountHolderStateRequest {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_DISABLE = "disable";
    private Boolean disable;
    public static final String JSON_PROPERTY_REASON = "reason";
    private String reason;
    public static final String JSON_PROPERTY_STATE_TYPE = "stateType";
    private StateTypeEnum stateType;

    public UpdateAccountHolderStateRequest accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the Account Holder on which to update the state.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public UpdateAccountHolderStateRequest disable(Boolean disable) {
        this.disable = disable;
        return this;
    }

    @ApiModelProperty(required=true, value="If true, disable the requested state.  If false, enable the requested state.")
    @JsonProperty(value="disable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDisable() {
        return this.disable;
    }

    @JsonProperty(value="disable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisable(Boolean disable) {
        this.disable = disable;
    }

    public UpdateAccountHolderStateRequest reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="The reason that the state is being updated. >Required if the state is being disabled.")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReason(String reason) {
        this.reason = reason;
    }

    public UpdateAccountHolderStateRequest stateType(StateTypeEnum stateType) {
        this.stateType = stateType;
        return this;
    }

    @ApiModelProperty(required=true, value="The state to be updated. >Permitted values are: `Processing`, `Payout`")
    @JsonProperty(value="stateType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StateTypeEnum getStateType() {
        return this.stateType;
    }

    @JsonProperty(value="stateType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStateType(StateTypeEnum stateType) {
        this.stateType = stateType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateAccountHolderStateRequest updateAccountHolderStateRequest = (UpdateAccountHolderStateRequest)o;
        return Objects.equals(this.accountHolderCode, updateAccountHolderStateRequest.accountHolderCode) && Objects.equals(this.disable, updateAccountHolderStateRequest.disable) && Objects.equals(this.reason, updateAccountHolderStateRequest.reason) && Objects.equals((Object)this.stateType, (Object)updateAccountHolderStateRequest.stateType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolderCode, this.disable, this.reason, this.stateType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateAccountHolderStateRequest {\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    disable: ").append(this.toIndentedString(this.disable)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    stateType: ").append(this.toIndentedString((Object)this.stateType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static UpdateAccountHolderStateRequest fromJson(String jsonString) throws JsonProcessingException {
        return (UpdateAccountHolderStateRequest)JSON.getMapper().readValue(jsonString, UpdateAccountHolderStateRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StateTypeEnum {
        LIMITEDPAYOUT("LimitedPayout"),
        LIMITEDPROCESSING("LimitedProcessing"),
        LIMITLESSPAYOUT("LimitlessPayout"),
        LIMITLESSPROCESSING("LimitlessProcessing"),
        PAYOUT("Payout"),
        PROCESSING("Processing");

        private String value;

        private StateTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateTypeEnum fromValue(String value) {
            for (StateTypeEnum b : StateTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

