/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"expirationDate", "issuerCountry", "issuerState", "number", "type"})
public class PersonalDocumentData {
    public static final String JSON_PROPERTY_EXPIRATION_DATE = "expirationDate";
    private String expirationDate;
    public static final String JSON_PROPERTY_ISSUER_COUNTRY = "issuerCountry";
    private String issuerCountry;
    public static final String JSON_PROPERTY_ISSUER_STATE = "issuerState";
    private String issuerState;
    public static final String JSON_PROPERTY_NUMBER = "number";
    private String number;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public PersonalDocumentData expirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    @ApiModelProperty(value="The expiry date of the document,   in ISO-8601 YYYY-MM-DD format. For example, **2000-01-31**.")
    @JsonProperty(value="expirationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpirationDate() {
        return this.expirationDate;
    }

    @JsonProperty(value="expirationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
    }

    public PersonalDocumentData issuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
        return this;
    }

    @ApiModelProperty(value="The country where the document was issued, in the two-character  [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format. For example, **NL**.")
    @JsonProperty(value="issuerCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuerCountry() {
        return this.issuerCountry;
    }

    @JsonProperty(value="issuerCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
    }

    public PersonalDocumentData issuerState(String issuerState) {
        this.issuerState = issuerState;
        return this;
    }

    @ApiModelProperty(value="The state where the document was issued (if applicable).")
    @JsonProperty(value="issuerState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuerState() {
        return this.issuerState;
    }

    @JsonProperty(value="issuerState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuerState(String issuerState) {
        this.issuerState = issuerState;
    }

    public PersonalDocumentData number(String number) {
        this.number = number;
        return this;
    }

    @ApiModelProperty(value="The number in the document.")
    @JsonProperty(value="number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNumber() {
        return this.number;
    }

    @JsonProperty(value="number")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumber(String number) {
        this.number = number;
    }

    public PersonalDocumentData type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of the document. Possible values: **ID**, **DRIVINGLICENSE**, **PASSPORT**, **SOCIALSECURITY**, **VISA**.  To delete an existing entry for a document `type`, send only the `type` field in your request. ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersonalDocumentData personalDocumentData = (PersonalDocumentData)o;
        return Objects.equals(this.expirationDate, personalDocumentData.expirationDate) && Objects.equals(this.issuerCountry, personalDocumentData.issuerCountry) && Objects.equals(this.issuerState, personalDocumentData.issuerState) && Objects.equals(this.number, personalDocumentData.number) && Objects.equals((Object)this.type, (Object)personalDocumentData.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.expirationDate, this.issuerCountry, this.issuerState, this.number, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PersonalDocumentData {\n");
        sb.append("    expirationDate: ").append(this.toIndentedString(this.expirationDate)).append("\n");
        sb.append("    issuerCountry: ").append(this.toIndentedString(this.issuerCountry)).append("\n");
        sb.append("    issuerState: ").append(this.toIndentedString(this.issuerState)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PersonalDocumentData fromJson(String jsonString) throws JsonProcessingException {
        return (PersonalDocumentData)JSON.getMapper().readValue(jsonString, PersonalDocumentData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        DRIVINGLICENSE("DRIVINGLICENSE"),
        ID("ID"),
        PASSPORT("PASSPORT"),
        SOCIALSECURITY("SOCIALSECURITY"),
        VISA("VISA");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

