/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.adyen.model.marketpayaccount.KYCCheckStatusData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"checks", "payoutMethodCode"})
public class KYCPayoutMethodCheckResult {
    public static final String JSON_PROPERTY_CHECKS = "checks";
    private List<KYCCheckStatusData> checks = null;
    public static final String JSON_PROPERTY_PAYOUT_METHOD_CODE = "payoutMethodCode";
    private String payoutMethodCode;

    public KYCPayoutMethodCheckResult checks(List<KYCCheckStatusData> checks) {
        this.checks = checks;
        return this;
    }

    public KYCPayoutMethodCheckResult addChecksItem(KYCCheckStatusData checksItem) {
        if (this.checks == null) {
            this.checks = new ArrayList<KYCCheckStatusData>();
        }
        this.checks.add(checksItem);
        return this;
    }

    @ApiModelProperty(value="A list of the checks and their statuses.")
    @JsonProperty(value="checks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<KYCCheckStatusData> getChecks() {
        return this.checks;
    }

    @JsonProperty(value="checks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChecks(List<KYCCheckStatusData> checks) {
        this.checks = checks;
    }

    public KYCPayoutMethodCheckResult payoutMethodCode(String payoutMethodCode) {
        this.payoutMethodCode = payoutMethodCode;
        return this;
    }

    @ApiModelProperty(value="The unique ID of the payoput method to which the check applies.")
    @JsonProperty(value="payoutMethodCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutMethodCode() {
        return this.payoutMethodCode;
    }

    @JsonProperty(value="payoutMethodCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutMethodCode(String payoutMethodCode) {
        this.payoutMethodCode = payoutMethodCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KYCPayoutMethodCheckResult kyCPayoutMethodCheckResult = (KYCPayoutMethodCheckResult)o;
        return Objects.equals(this.checks, kyCPayoutMethodCheckResult.checks) && Objects.equals(this.payoutMethodCode, kyCPayoutMethodCheckResult.payoutMethodCode);
    }

    public int hashCode() {
        return Objects.hash(this.checks, this.payoutMethodCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KYCPayoutMethodCheckResult {\n");
        sb.append("    checks: ").append(this.toIndentedString(this.checks)).append("\n");
        sb.append("    payoutMethodCode: ").append(this.toIndentedString(this.payoutMethodCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static KYCPayoutMethodCheckResult fromJson(String jsonString) throws JsonProcessingException {
        return (KYCPayoutMethodCheckResult)JSON.getMapper().readValue(jsonString, KYCPayoutMethodCheckResult.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

