/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderCode", "formType", "year"})
public class GetTaxFormRequest {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_FORM_TYPE = "formType";
    private String formType;
    public static final String JSON_PROPERTY_YEAR = "year";
    private Integer year;

    public GetTaxFormRequest accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The account holder code you provided when you created the account holder.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public GetTaxFormRequest formType(String formType) {
        this.formType = formType;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of the requested tax form. For example, 1099-K.")
    @JsonProperty(value="formType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFormType() {
        return this.formType;
    }

    @JsonProperty(value="formType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormType(String formType) {
        this.formType = formType;
    }

    public GetTaxFormRequest year(Integer year) {
        this.year = year;
        return this;
    }

    @ApiModelProperty(required=true, value="Applicable tax year in the YYYY format.")
    @JsonProperty(value="year")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getYear() {
        return this.year;
    }

    @JsonProperty(value="year")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setYear(Integer year) {
        this.year = year;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTaxFormRequest getTaxFormRequest = (GetTaxFormRequest)o;
        return Objects.equals(this.accountHolderCode, getTaxFormRequest.accountHolderCode) && Objects.equals(this.formType, getTaxFormRequest.formType) && Objects.equals(this.year, getTaxFormRequest.year);
    }

    public int hashCode() {
        return Objects.hash(this.accountHolderCode, this.formType, this.year);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetTaxFormRequest {\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    formType: ").append(this.toIndentedString(this.formType)).append("\n");
        sb.append("    year: ").append(this.toIndentedString(this.year)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static GetTaxFormRequest fromJson(String jsonString) throws JsonProcessingException {
        return (GetTaxFormRequest)JSON.getMapper().readValue(jsonString, GetTaxFormRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

