/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.Profile;
import com.adyen.model.management.Settings;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"profiles", "settings"})
public class WifiProfiles {
    public static final String JSON_PROPERTY_PROFILES = "profiles";
    private List<Profile> profiles = null;
    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private Settings settings;

    public WifiProfiles profiles(List<Profile> profiles) {
        this.profiles = profiles;
        return this;
    }

    public WifiProfiles addProfilesItem(Profile profilesItem) {
        if (this.profiles == null) {
            this.profiles = new ArrayList<Profile>();
        }
        this.profiles.add(profilesItem);
        return this;
    }

    @ApiModelProperty(value="List of remote Wi-Fi profiles.")
    @JsonProperty(value="profiles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Profile> getProfiles() {
        return this.profiles;
    }

    @JsonProperty(value="profiles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfiles(List<Profile> profiles) {
        this.profiles = profiles;
    }

    public WifiProfiles settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Settings getSettings() {
        return this.settings;
    }

    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WifiProfiles wifiProfiles = (WifiProfiles)o;
        return Objects.equals(this.profiles, wifiProfiles.profiles) && Objects.equals(this.settings, wifiProfiles.settings);
    }

    public int hashCode() {
        return Objects.hash(this.profiles, this.settings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WifiProfiles {\n");
        sb.append("    profiles: ").append(this.toIndentedString(this.profiles)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static WifiProfiles fromJson(String jsonString) throws JsonProcessingException {
        return (WifiProfiles)JSON.getMapper().readValue(jsonString, WifiProfiles.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

