/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"directCapture", "payerId", "subject"})
public class PayPalInfo {
    public static final String JSON_PROPERTY_DIRECT_CAPTURE = "directCapture";
    private Boolean directCapture;
    public static final String JSON_PROPERTY_PAYER_ID = "payerId";
    private String payerId;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject;

    public PayPalInfo directCapture(Boolean directCapture) {
        this.directCapture = directCapture;
        return this;
    }

    @ApiModelProperty(value="Indicates if direct (immediate) capture for PayPal is enabled. If set to **true**, this setting overrides the [capture](https://docs.adyen.com/online-payments/capture) settings of your merchant account. Default value: **true**.")
    @JsonProperty(value="directCapture")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDirectCapture() {
        return this.directCapture;
    }

    @JsonProperty(value="directCapture")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDirectCapture(Boolean directCapture) {
        this.directCapture = directCapture;
    }

    public PayPalInfo payerId(String payerId) {
        this.payerId = payerId;
        return this;
    }

    @ApiModelProperty(required=true, value="PayPal Merchant ID. Character length and limitations: 13 single-byte alphanumeric characters.")
    @JsonProperty(value="payerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayerId() {
        return this.payerId;
    }

    @JsonProperty(value="payerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayerId(String payerId) {
        this.payerId = payerId;
    }

    public PayPalInfo subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(required=true, value="Your business email address.")
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayPalInfo payPalInfo = (PayPalInfo)o;
        return Objects.equals(this.directCapture, payPalInfo.directCapture) && Objects.equals(this.payerId, payPalInfo.payerId) && Objects.equals(this.subject, payPalInfo.subject);
    }

    public int hashCode() {
        return Objects.hash(this.directCapture, this.payerId, this.subject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayPalInfo {\n");
        sb.append("    directCapture: ").append(this.toIndentedString(this.directCapture)).append("\n");
        sb.append("    payerId: ").append(this.toIndentedString(this.payerId)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PayPalInfo fromJson(String jsonString) throws JsonProcessingException {
        return (PayPalInfo)JSON.getMapper().readValue(jsonString, PayPalInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

