/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.TransactionDescriptionInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"midNumber", "reuseMidNumber", "serviceLevel", "transactionDescription"})
public class DinersInfo {
    public static final String JSON_PROPERTY_MID_NUMBER = "midNumber";
    private String midNumber;
    public static final String JSON_PROPERTY_REUSE_MID_NUMBER = "reuseMidNumber";
    private Boolean reuseMidNumber;
    public static final String JSON_PROPERTY_SERVICE_LEVEL = "serviceLevel";
    private ServiceLevelEnum serviceLevel;
    public static final String JSON_PROPERTY_TRANSACTION_DESCRIPTION = "transactionDescription";
    private TransactionDescriptionInfo transactionDescription;

    public DinersInfo midNumber(String midNumber) {
        this.midNumber = midNumber;
        return this;
    }

    @ApiModelProperty(value="MID (Merchant ID) number. Required for merchants operating in Japan. Format: 14 numeric characters.")
    @JsonProperty(value="midNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMidNumber() {
        return this.midNumber;
    }

    @JsonProperty(value="midNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMidNumber(String midNumber) {
        this.midNumber = midNumber;
    }

    public DinersInfo reuseMidNumber(Boolean reuseMidNumber) {
        this.reuseMidNumber = reuseMidNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether the JCB Merchant ID is reused from a previously configured JCB payment method. The default value is **false**. For merchants operating in Japan, this field is required and must be set to **true**.")
    @JsonProperty(value="reuseMidNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReuseMidNumber() {
        return this.reuseMidNumber;
    }

    @JsonProperty(value="reuseMidNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReuseMidNumber(Boolean reuseMidNumber) {
        this.reuseMidNumber = reuseMidNumber;
    }

    public DinersInfo serviceLevel(ServiceLevelEnum serviceLevel) {
        this.serviceLevel = serviceLevel;
        return this;
    }

    @ApiModelProperty(value="Specifies the service level (settlement type) of this payment method. Required for merchants operating in Japan. Possible values:  * **noContract**: Adyen holds the contract with JCB.  * **gatewayContract**: JCB receives the settlement and handles disputes, then pays out to you or your sub-merchant directly.")
    @JsonProperty(value="serviceLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ServiceLevelEnum getServiceLevel() {
        return this.serviceLevel;
    }

    @JsonProperty(value="serviceLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setServiceLevel(ServiceLevelEnum serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    public DinersInfo transactionDescription(TransactionDescriptionInfo transactionDescription) {
        this.transactionDescription = transactionDescription;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="transactionDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransactionDescriptionInfo getTransactionDescription() {
        return this.transactionDescription;
    }

    @JsonProperty(value="transactionDescription")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransactionDescription(TransactionDescriptionInfo transactionDescription) {
        this.transactionDescription = transactionDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DinersInfo dinersInfo = (DinersInfo)o;
        return Objects.equals(this.midNumber, dinersInfo.midNumber) && Objects.equals(this.reuseMidNumber, dinersInfo.reuseMidNumber) && Objects.equals((Object)this.serviceLevel, (Object)dinersInfo.serviceLevel) && Objects.equals(this.transactionDescription, dinersInfo.transactionDescription);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.midNumber, this.reuseMidNumber, this.serviceLevel, this.transactionDescription});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DinersInfo {\n");
        sb.append("    midNumber: ").append(this.toIndentedString(this.midNumber)).append("\n");
        sb.append("    reuseMidNumber: ").append(this.toIndentedString(this.reuseMidNumber)).append("\n");
        sb.append("    serviceLevel: ").append(this.toIndentedString((Object)this.serviceLevel)).append("\n");
        sb.append("    transactionDescription: ").append(this.toIndentedString(this.transactionDescription)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DinersInfo fromJson(String jsonString) throws JsonProcessingException {
        return (DinersInfo)JSON.getMapper().readValue(jsonString, DinersInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ServiceLevelEnum {
        NOCONTRACT("noContract"),
        GATEWAYCONTRACT("gatewayContract");

        private String value;

        private ServiceLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServiceLevelEnum fromValue(String value) {
            for (ServiceLevelEnum b : ServiceLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

