/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.CompanyLinks;
import com.adyen.model.management.DataCenter;
import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"_links", "dataCenters", "description", "id", "name", "reference", "status"})
public class Company {
    public static final String JSON_PROPERTY_LINKS = "_links";
    private CompanyLinks links;
    public static final String JSON_PROPERTY_DATA_CENTERS = "dataCenters";
    private List<DataCenter> dataCenters = null;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;

    public Company links(CompanyLinks links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CompanyLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(CompanyLinks links) {
        this.links = links;
    }

    public Company dataCenters(List<DataCenter> dataCenters) {
        this.dataCenters = dataCenters;
        return this;
    }

    public Company addDataCentersItem(DataCenter dataCentersItem) {
        if (this.dataCenters == null) {
            this.dataCenters = new ArrayList<DataCenter>();
        }
        this.dataCenters.add(dataCentersItem);
        return this;
    }

    @ApiModelProperty(value="List of available data centers.  Adyen has several data centers around the world.In the URL that you use for making API requests, we recommend you use the live URL prefix from the data center closest to your shoppers.")
    @JsonProperty(value="dataCenters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DataCenter> getDataCenters() {
        return this.dataCenters;
    }

    @JsonProperty(value="dataCenters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataCenters(List<DataCenter> dataCenters) {
        this.dataCenters = dataCenters;
    }

    public Company description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for the company account, maximum 300 characters")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public Company id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the company account.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Company name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The legal or trading name of the company.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public Company reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference to the account")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public Company status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the company account.  Possible values:  * **Active**: Users can log in. Processing and payout capabilities depend on the status of the merchant account. * **Inactive**: Users can log in. Payment processing and payouts are disabled. * **Closed**: The company account is closed and this cannot be reversed. Users cannot log in. Payment processing and payouts are disabled.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Company company = (Company)o;
        return Objects.equals(this.links, company.links) && Objects.equals(this.dataCenters, company.dataCenters) && Objects.equals(this.description, company.description) && Objects.equals(this.id, company.id) && Objects.equals(this.name, company.name) && Objects.equals(this.reference, company.reference) && Objects.equals(this.status, company.status);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.dataCenters, this.description, this.id, this.name, this.reference, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Company {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    dataCenters: ").append(this.toIndentedString(this.dataCenters)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Company fromJson(String jsonString) throws JsonProcessingException {
        return (Company)JSON.getMapper().readValue(jsonString, Company.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

