/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.Address;
import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.TaxInformation;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"countryOfGoverningLaw", "dateOfIncorporation", "description", "doingBusinessAs", "name", "principalPlaceOfBusiness", "registeredAddress", "registrationNumber", "taxInformation", "type", "vatAbsenceReason", "vatNumber"})
public class UnincorporatedPartnership {
    public static final String JSON_PROPERTY_COUNTRY_OF_GOVERNING_LAW = "countryOfGoverningLaw";
    private String countryOfGoverningLaw;
    public static final String JSON_PROPERTY_DATE_OF_INCORPORATION = "dateOfIncorporation";
    private String dateOfIncorporation;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DOING_BUSINESS_AS = "doingBusinessAs";
    private String doingBusinessAs;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PRINCIPAL_PLACE_OF_BUSINESS = "principalPlaceOfBusiness";
    private Address principalPlaceOfBusiness;
    public static final String JSON_PROPERTY_REGISTERED_ADDRESS = "registeredAddress";
    private Address registeredAddress;
    public static final String JSON_PROPERTY_REGISTRATION_NUMBER = "registrationNumber";
    private String registrationNumber;
    public static final String JSON_PROPERTY_TAX_INFORMATION = "taxInformation";
    private List<TaxInformation> taxInformation = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_VAT_ABSENCE_REASON = "vatAbsenceReason";
    private VatAbsenceReasonEnum vatAbsenceReason;
    public static final String JSON_PROPERTY_VAT_NUMBER = "vatNumber";
    private String vatNumber;

    public UnincorporatedPartnership countryOfGoverningLaw(String countryOfGoverningLaw) {
        this.countryOfGoverningLaw = countryOfGoverningLaw;
        return this;
    }

    @ApiModelProperty(required=true, value="The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code of the governing country.")
    @JsonProperty(value="countryOfGoverningLaw")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryOfGoverningLaw() {
        return this.countryOfGoverningLaw;
    }

    @JsonProperty(value="countryOfGoverningLaw")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountryOfGoverningLaw(String countryOfGoverningLaw) {
        this.countryOfGoverningLaw = countryOfGoverningLaw;
    }

    public UnincorporatedPartnership dateOfIncorporation(String dateOfIncorporation) {
        this.dateOfIncorporation = dateOfIncorporation;
        return this;
    }

    @ApiModelProperty(value="The date when the legal arrangement was incorporated in YYYY-MM-DD format.")
    @JsonProperty(value="dateOfIncorporation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDateOfIncorporation() {
        return this.dateOfIncorporation;
    }

    @JsonProperty(value="dateOfIncorporation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDateOfIncorporation(String dateOfIncorporation) {
        this.dateOfIncorporation = dateOfIncorporation;
    }

    public UnincorporatedPartnership description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Short description about the Legal Arrangement.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public UnincorporatedPartnership doingBusinessAs(String doingBusinessAs) {
        this.doingBusinessAs = doingBusinessAs;
        return this;
    }

    @ApiModelProperty(value="The registered name, if different from the `name`.")
    @JsonProperty(value="doingBusinessAs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDoingBusinessAs() {
        return this.doingBusinessAs;
    }

    @JsonProperty(value="doingBusinessAs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDoingBusinessAs(String doingBusinessAs) {
        this.doingBusinessAs = doingBusinessAs;
    }

    public UnincorporatedPartnership name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The legal name.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public UnincorporatedPartnership principalPlaceOfBusiness(Address principalPlaceOfBusiness) {
        this.principalPlaceOfBusiness = principalPlaceOfBusiness;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="principalPlaceOfBusiness")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getPrincipalPlaceOfBusiness() {
        return this.principalPlaceOfBusiness;
    }

    @JsonProperty(value="principalPlaceOfBusiness")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrincipalPlaceOfBusiness(Address principalPlaceOfBusiness) {
        this.principalPlaceOfBusiness = principalPlaceOfBusiness;
    }

    public UnincorporatedPartnership registeredAddress(Address registeredAddress) {
        this.registeredAddress = registeredAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="registeredAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getRegisteredAddress() {
        return this.registeredAddress;
    }

    @JsonProperty(value="registeredAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRegisteredAddress(Address registeredAddress) {
        this.registeredAddress = registeredAddress;
    }

    public UnincorporatedPartnership registrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
        return this;
    }

    @ApiModelProperty(value="The registration number.")
    @JsonProperty(value="registrationNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    @JsonProperty(value="registrationNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRegistrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    public UnincorporatedPartnership taxInformation(List<TaxInformation> taxInformation) {
        this.taxInformation = taxInformation;
        return this;
    }

    public UnincorporatedPartnership addTaxInformationItem(TaxInformation taxInformationItem) {
        if (this.taxInformation == null) {
            this.taxInformation = new ArrayList<TaxInformation>();
        }
        this.taxInformation.add(taxInformationItem);
        return this;
    }

    @ApiModelProperty(value="The tax information of the entity.")
    @JsonProperty(value="taxInformation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TaxInformation> getTaxInformation() {
        return this.taxInformation;
    }

    @JsonProperty(value="taxInformation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaxInformation(List<TaxInformation> taxInformation) {
        this.taxInformation = taxInformation;
    }

    public UnincorporatedPartnership type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Type of Partnership.  Possible values: *  **limitedPartnership** *  **generalPartnership** *  **familyPartnership** *  **commercialPartnership** *  **publicPartnership** *  **otherPartnership** *  **gbr** *  **gmbh** *  **kgaa** *  **cv** *  **vof** *  **maatschap** *  **privateFundLimitedPartnership** *  **businessTrustEntity** *  **businessPartnership** *  **limitedLiabilityPartnership** *  **eg** *  **cooperative** *  **vos** *  **comunidadDeBienes** *  **herenciaYacente** *  **comunidadDePropietarios** *  **sep** *  **sca** *  **bt** *  **kkt** *  **scs** *  **snc**  ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public UnincorporatedPartnership vatAbsenceReason(VatAbsenceReasonEnum vatAbsenceReason) {
        this.vatAbsenceReason = vatAbsenceReason;
        return this;
    }

    @ApiModelProperty(value="The reason for not providing a VAT number.  Possible values: **industryExemption**, **belowTaxThreshold**.")
    @JsonProperty(value="vatAbsenceReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public VatAbsenceReasonEnum getVatAbsenceReason() {
        return this.vatAbsenceReason;
    }

    @JsonProperty(value="vatAbsenceReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVatAbsenceReason(VatAbsenceReasonEnum vatAbsenceReason) {
        this.vatAbsenceReason = vatAbsenceReason;
    }

    public UnincorporatedPartnership vatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
        return this;
    }

    @ApiModelProperty(value="The VAT number.")
    @JsonProperty(value="vatNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVatNumber() {
        return this.vatNumber;
    }

    @JsonProperty(value="vatNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnincorporatedPartnership unincorporatedPartnership = (UnincorporatedPartnership)o;
        return Objects.equals(this.countryOfGoverningLaw, unincorporatedPartnership.countryOfGoverningLaw) && Objects.equals(this.dateOfIncorporation, unincorporatedPartnership.dateOfIncorporation) && Objects.equals(this.description, unincorporatedPartnership.description) && Objects.equals(this.doingBusinessAs, unincorporatedPartnership.doingBusinessAs) && Objects.equals(this.name, unincorporatedPartnership.name) && Objects.equals(this.principalPlaceOfBusiness, unincorporatedPartnership.principalPlaceOfBusiness) && Objects.equals(this.registeredAddress, unincorporatedPartnership.registeredAddress) && Objects.equals(this.registrationNumber, unincorporatedPartnership.registrationNumber) && Objects.equals(this.taxInformation, unincorporatedPartnership.taxInformation) && Objects.equals((Object)this.type, (Object)unincorporatedPartnership.type) && Objects.equals((Object)this.vatAbsenceReason, (Object)unincorporatedPartnership.vatAbsenceReason) && Objects.equals(this.vatNumber, unincorporatedPartnership.vatNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.countryOfGoverningLaw, this.dateOfIncorporation, this.description, this.doingBusinessAs, this.name, this.principalPlaceOfBusiness, this.registeredAddress, this.registrationNumber, this.taxInformation, this.type, this.vatAbsenceReason, this.vatNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UnincorporatedPartnership {\n");
        sb.append("    countryOfGoverningLaw: ").append(this.toIndentedString(this.countryOfGoverningLaw)).append("\n");
        sb.append("    dateOfIncorporation: ").append(this.toIndentedString(this.dateOfIncorporation)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    doingBusinessAs: ").append(this.toIndentedString(this.doingBusinessAs)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    principalPlaceOfBusiness: ").append(this.toIndentedString(this.principalPlaceOfBusiness)).append("\n");
        sb.append("    registeredAddress: ").append(this.toIndentedString(this.registeredAddress)).append("\n");
        sb.append("    registrationNumber: ").append(this.toIndentedString(this.registrationNumber)).append("\n");
        sb.append("    taxInformation: ").append(this.toIndentedString(this.taxInformation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    vatAbsenceReason: ").append(this.toIndentedString((Object)this.vatAbsenceReason)).append("\n");
        sb.append("    vatNumber: ").append(this.toIndentedString(this.vatNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static UnincorporatedPartnership fromJson(String jsonString) throws JsonProcessingException {
        return (UnincorporatedPartnership)JSON.getMapper().readValue(jsonString, UnincorporatedPartnership.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum VatAbsenceReasonEnum {
        INDUSTRYEXEMPTION("industryExemption"),
        BELOWTAXTHRESHOLD("belowTaxThreshold");

        private String value;

        private VatAbsenceReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VatAbsenceReasonEnum fromValue(String value) {
            for (VatAbsenceReasonEnum b : VatAbsenceReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        LIMITEDPARTNERSHIP("limitedPartnership"),
        GENERALPARTNERSHIP("generalPartnership"),
        FAMILYPARTNERSHIP("familyPartnership"),
        COMMERCIALPARTNERSHIP("commercialPartnership"),
        PUBLICPARTNERSHIP("publicPartnership"),
        OTHERPARTNERSHIP("otherPartnership"),
        GBR("gbr"),
        GMBH("gmbh"),
        KGAA("kgaa"),
        CV("cv"),
        VOF("vof"),
        MAATSCHAP("maatschap"),
        PRIVATEFUNDLIMITEDPARTNERSHIP("privateFundLimitedPartnership"),
        BUSINESSTRUSTENTITY("businessTrustEntity"),
        BUSINESSPARTNERSHIP("businessPartnership"),
        LIMITEDLIABILITYPARTNERSHIP("limitedLiabilityPartnership"),
        EG("eg"),
        COOPERATIVE("cooperative"),
        VOS("vos"),
        COMUNIDADDEBIENES("comunidadDeBienes"),
        HERENCIAYACENTE("herenciaYacente"),
        COMUNIDADDEPROPIETARIOS("comunidadDePropietarios"),
        SEP("sep"),
        SCA("sca"),
        BT("bt"),
        KKT("kkt"),
        SCS("scs"),
        SNC("snc");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

