/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"documents", "id", "type"})
@JsonTypeName(value="CapabilityProblemEntity-recursive")
public class CapabilityProblemEntityRecursive {
    public static final String JSON_PROPERTY_DOCUMENTS = "documents";
    private List<String> documents = null;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public CapabilityProblemEntityRecursive documents(List<String> documents) {
        this.documents = documents;
        return this;
    }

    public CapabilityProblemEntityRecursive addDocumentsItem(String documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<String>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    @ApiModelProperty(value="List of document IDs corresponding to the verification errors from capabilities.")
    @JsonProperty(value="documents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDocuments() {
        return this.documents;
    }

    @JsonProperty(value="documents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocuments(List<String> documents) {
        this.documents = documents;
    }

    public CapabilityProblemEntityRecursive id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public CapabilityProblemEntityRecursive type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapabilityProblemEntityRecursive capabilityProblemEntityRecursive = (CapabilityProblemEntityRecursive)o;
        return Objects.equals(this.documents, capabilityProblemEntityRecursive.documents) && Objects.equals(this.id, capabilityProblemEntityRecursive.id) && Objects.equals((Object)this.type, (Object)capabilityProblemEntityRecursive.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.documents, this.id, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CapabilityProblemEntityRecursive {\n");
        sb.append("    documents: ").append(this.toIndentedString(this.documents)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CapabilityProblemEntityRecursive fromJson(String jsonString) throws JsonProcessingException {
        return (CapabilityProblemEntityRecursive)JSON.getMapper().readValue(jsonString, CapabilityProblemEntityRecursive.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        BANKACCOUNT("BankAccount"),
        DOCUMENT("Document"),
        LEGALENTITY("LegalEntity"),
        PRODUCT("product");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

