/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.serializer.ByteArrayDeserializer;
import com.adyen.serializer.ByteArraySerializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.ext.ContextResolver;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JSON
implements ContextResolver<ObjectMapper> {
    private static ObjectMapper mapper;
    private static Map<Class<?>, ClassDiscriminatorMapping> modelDiscriminators;
    private static Map<Class<?>, Map<String, GenericType>> modelDescendants;
    private static JSON json;

    public JSON() {
        mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        JsonMapper.builder().configure(MapperFeature.ALLOW_COERCION_OF_SCALARS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, true);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
        mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        mapper.registerModule((Module)new JavaTimeModule());
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(byte[].class, (JsonSerializer)new ByteArraySerializer());
        simpleModule.addDeserializer(byte[].class, (JsonDeserializer)new ByteArrayDeserializer());
        mapper.registerModule((Module)simpleModule);
    }

    public void setDateFormat(DateFormat dateFormat) {
        mapper.setDateFormat(dateFormat);
    }

    public ObjectMapper getContext(Class<?> type) {
        return mapper;
    }

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static Class<?> getClassForElement(JsonNode node, Class<?> modelClass) {
        ClassDiscriminatorMapping cdm = modelDiscriminators.get(modelClass);
        if (cdm != null) {
            return cdm.getClassForElement(node, new HashSet());
        }
        return null;
    }

    public static boolean isInstanceOf(Class<?> modelClass, Object inst, Set<Class<?>> visitedClasses) {
        if (modelClass.isInstance(inst)) {
            return true;
        }
        if (visitedClasses.contains(modelClass)) {
            return false;
        }
        visitedClasses.add(modelClass);
        Map<String, GenericType> descendants = modelDescendants.get(modelClass);
        if (descendants != null) {
            for (GenericType childType : descendants.values()) {
                if (!JSON.isInstanceOf(childType.getRawType(), inst, visitedClasses)) continue;
                return true;
            }
        }
        return false;
    }

    public static void registerDiscriminator(Class<?> modelClass, String discriminatorPropertyName, Map<String, Class<?>> mappings) {
        ClassDiscriminatorMapping m = new ClassDiscriminatorMapping(modelClass, discriminatorPropertyName, mappings);
        modelDiscriminators.put(modelClass, m);
    }

    public static void registerDescendants(Class<?> modelClass, Map<String, GenericType> descendants) {
        modelDescendants.put(modelClass, descendants);
    }

    public static JSON getDefault() {
        return json;
    }

    public static void setDefault(JSON json) {
        JSON.json = json;
    }

    static {
        modelDiscriminators = new HashMap();
        modelDescendants = new HashMap();
        json = new JSON();
    }

    private static class ClassDiscriminatorMapping {
        Class<?> modelClass;
        String discriminatorName;
        Map<String, Class<?>> discriminatorMappings;

        ClassDiscriminatorMapping(Class<?> cls, String propertyName, Map<String, Class<?>> mappings) {
            this.modelClass = cls;
            this.discriminatorName = propertyName;
            this.discriminatorMappings = new HashMap();
            if (mappings != null) {
                this.discriminatorMappings.putAll(mappings);
            }
        }

        String getDiscriminatorPropertyName() {
            return this.discriminatorName;
        }

        String getDiscriminatorValue(JsonNode node) {
            String discrValue;
            if (this.discriminatorName != null && (node = node.get(this.discriminatorName)) != null && node.isValueNode() && (discrValue = node.asText()) != null) {
                return discrValue;
            }
            return null;
        }

        Class<?> getClassForElement(JsonNode node, Set<Class<?>> visitedClasses) {
            if (visitedClasses.contains(this.modelClass)) {
                return null;
            }
            String discrValue = this.getDiscriminatorValue(node);
            if (discrValue == null) {
                return null;
            }
            Class<?> cls = this.discriminatorMappings.get(discrValue);
            visitedClasses.add(this.modelClass);
            for (Class<?> childClass : this.discriminatorMappings.values()) {
                Class<?> childDiscr;
                ClassDiscriminatorMapping childCdm = (ClassDiscriminatorMapping)modelDiscriminators.get(childClass);
                if (childCdm == null || !this.discriminatorName.equals(childCdm.discriminatorName) && (discrValue = this.getDiscriminatorValue(node)) == null || childCdm == null || (childDiscr = childCdm.getClassForElement(node, visitedClasses)) == null) continue;
                return childDiscr;
            }
            return cls;
        }
    }
}

