/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"clientData", "customFields", "fraudOffset", "profileReference"})
public class RiskData {
    public static final String JSON_PROPERTY_CLIENT_DATA = "clientData";
    private String clientData;
    public static final String JSON_PROPERTY_CUSTOM_FIELDS = "customFields";
    private Map<String, String> customFields = null;
    public static final String JSON_PROPERTY_FRAUD_OFFSET = "fraudOffset";
    private Integer fraudOffset;
    public static final String JSON_PROPERTY_PROFILE_REFERENCE = "profileReference";
    private String profileReference;

    public RiskData clientData(String clientData) {
        this.clientData = clientData;
        return this;
    }

    @ApiModelProperty(value="Contains client-side data, like the device fingerprint, cookies, and specific browser settings.")
    @JsonProperty(value="clientData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientData() {
        return this.clientData;
    }

    @JsonProperty(value="clientData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientData(String clientData) {
        this.clientData = clientData;
    }

    public RiskData customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public RiskData putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @ApiModelProperty(value="Any custom fields used as part of the input to configured risk rules.")
    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    @JsonProperty(value="customFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    public RiskData fraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
        return this;
    }

    @ApiModelProperty(value="An integer value that is added to the normal fraud score. The value can be either positive or negative.")
    @JsonProperty(value="fraudOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFraudOffset() {
        return this.fraudOffset;
    }

    @JsonProperty(value="fraudOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
    }

    public RiskData profileReference(String profileReference) {
        this.profileReference = profileReference;
        return this;
    }

    @ApiModelProperty(value="The risk profile to assign to this payment. When left empty, the merchant-level account's default risk profile will be applied.")
    @JsonProperty(value="profileReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProfileReference() {
        return this.profileReference;
    }

    @JsonProperty(value="profileReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfileReference(String profileReference) {
        this.profileReference = profileReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RiskData riskData = (RiskData)o;
        return Objects.equals(this.clientData, riskData.clientData) && Objects.equals(this.customFields, riskData.customFields) && Objects.equals(this.fraudOffset, riskData.fraudOffset) && Objects.equals(this.profileReference, riskData.profileReference);
    }

    public int hashCode() {
        return Objects.hash(this.clientData, this.customFields, this.fraudOffset, this.profileReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RiskData {\n");
        sb.append("    clientData: ").append(this.toIndentedString(this.clientData)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    fraudOffset: ").append(this.toIndentedString(this.fraudOffset)).append("\n");
        sb.append("    profileReference: ").append(this.toIndentedString(this.profileReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static RiskData fromJson(String jsonString) throws JsonProcessingException {
        return (RiskData)JSON.getMapper().readValue(jsonString, RiskData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

