/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.CardInfo;
import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"balanceAccountId", "card", "status", "statusComment", "statusReason"})
public class PaymentInstrumentUpdateRequest {
    public static final String JSON_PROPERTY_BALANCE_ACCOUNT_ID = "balanceAccountId";
    private String balanceAccountId;
    public static final String JSON_PROPERTY_CARD = "card";
    private CardInfo card;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_STATUS_COMMENT = "statusComment";
    private String statusComment;
    public static final String JSON_PROPERTY_STATUS_REASON = "statusReason";
    private StatusReasonEnum statusReason;

    public PaymentInstrumentUpdateRequest balanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the balance account associated with this payment instrument. >You can only change the balance account ID if the payment instrument has **inactive** status.")
    @JsonProperty(value="balanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalanceAccountId() {
        return this.balanceAccountId;
    }

    @JsonProperty(value="balanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
    }

    public PaymentInstrumentUpdateRequest card(CardInfo card) {
        this.card = card;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="card")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CardInfo getCard() {
        return this.card;
    }

    @JsonProperty(value="card")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCard(CardInfo card) {
        this.card = card;
    }

    public PaymentInstrumentUpdateRequest status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the payment instrument. If a status is not specified when creating a payment instrument, it is set to **active** by default. However, there can be exceptions for cards based on the `card.formFactor` and the `issuingCountryCode`. For example, when issuing physical cards in the US, the default status is **inactive**.  Possible values:    * **active**:  The payment instrument is active and can be used to make payments.    * **inactive**: The payment instrument is inactive and cannot be used to make payments.    * **suspended**: The payment instrument is suspended, either because it was stolen or lost.    * **closed**: The payment instrument is permanently closed. This action cannot be undone.   ")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public PaymentInstrumentUpdateRequest statusComment(String statusComment) {
        this.statusComment = statusComment;
        return this;
    }

    @ApiModelProperty(value="Comment for the status of the payment instrument.  Required if `statusReason` is **other**.")
    @JsonProperty(value="statusComment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatusComment() {
        return this.statusComment;
    }

    @JsonProperty(value="statusComment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatusComment(String statusComment) {
        this.statusComment = statusComment;
    }

    public PaymentInstrumentUpdateRequest statusReason(StatusReasonEnum statusReason) {
        this.statusReason = statusReason;
        return this;
    }

    @ApiModelProperty(value="The reason for updating the status of the payment instrument.  Possible values: **lost**, **stolen**, **damaged**, **suspectedFraud**, **expired**, **endOfLife**, **accountClosure**, **other**. If the reason is **other**, you must also send the `statusComment` parameter describing the status change.")
    @JsonProperty(value="statusReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusReasonEnum getStatusReason() {
        return this.statusReason;
    }

    @JsonProperty(value="statusReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatusReason(StatusReasonEnum statusReason) {
        this.statusReason = statusReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInstrumentUpdateRequest paymentInstrumentUpdateRequest = (PaymentInstrumentUpdateRequest)o;
        return Objects.equals(this.balanceAccountId, paymentInstrumentUpdateRequest.balanceAccountId) && Objects.equals(this.card, paymentInstrumentUpdateRequest.card) && Objects.equals((Object)this.status, (Object)paymentInstrumentUpdateRequest.status) && Objects.equals(this.statusComment, paymentInstrumentUpdateRequest.statusComment) && Objects.equals((Object)this.statusReason, (Object)paymentInstrumentUpdateRequest.statusReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.balanceAccountId, this.card, this.status, this.statusComment, this.statusReason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInstrumentUpdateRequest {\n");
        sb.append("    balanceAccountId: ").append(this.toIndentedString(this.balanceAccountId)).append("\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusComment: ").append(this.toIndentedString(this.statusComment)).append("\n");
        sb.append("    statusReason: ").append(this.toIndentedString((Object)this.statusReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentInstrumentUpdateRequest fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentInstrumentUpdateRequest)JSON.getMapper().readValue(jsonString, PaymentInstrumentUpdateRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusReasonEnum {
        ACCOUNTCLOSURE("accountClosure"),
        DAMAGED("damaged"),
        ENDOFLIFE("endOfLife"),
        EXPIRED("expired"),
        LOST("lost"),
        OTHER("other"),
        STOLEN("stolen"),
        SUSPECTEDFRAUD("suspectedFraud"),
        TRANSACTIONRULE("transactionRule");

        private String value;

        private StatusReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusReasonEnum fromValue(String value) {
            for (StatusReasonEnum b : StatusReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        ACTIVE("active"),
        CLOSED("closed"),
        INACTIVE("inactive"),
        SUSPENDED("suspended");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

