/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transferwebhooks;

import com.adyen.model.transferwebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"balance", "currency", "received", "reserved"})
public class BalanceMutation {
    public static final String JSON_PROPERTY_BALANCE = "balance";
    private Long balance;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    public static final String JSON_PROPERTY_RECEIVED = "received";
    private Long received;
    public static final String JSON_PROPERTY_RESERVED = "reserved";
    private Long reserved;

    public BalanceMutation balance(Long balance) {
        this.balance = balance;
        return this;
    }

    @ApiModelProperty(value="The amount in the payment's currency that is debited or credited on the balance accounting register.")
    @JsonProperty(value="balance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getBalance() {
        return this.balance;
    }

    @JsonProperty(value="balance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalance(Long balance) {
        this.balance = balance;
    }

    public BalanceMutation currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(value="The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes).")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BalanceMutation received(Long received) {
        this.received = received;
        return this;
    }

    @ApiModelProperty(value="The amount in the payment's currency that is debited or credited on the received accounting register.")
    @JsonProperty(value="received")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getReceived() {
        return this.received;
    }

    @JsonProperty(value="received")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReceived(Long received) {
        this.received = received;
    }

    public BalanceMutation reserved(Long reserved) {
        this.reserved = reserved;
        return this;
    }

    @ApiModelProperty(value="The amount in the payment's currency that is debited or credited on the reserved accounting register.")
    @JsonProperty(value="reserved")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getReserved() {
        return this.reserved;
    }

    @JsonProperty(value="reserved")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReserved(Long reserved) {
        this.reserved = reserved;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceMutation balanceMutation = (BalanceMutation)o;
        return Objects.equals(this.balance, balanceMutation.balance) && Objects.equals(this.currency, balanceMutation.currency) && Objects.equals(this.received, balanceMutation.received) && Objects.equals(this.reserved, balanceMutation.reserved);
    }

    public int hashCode() {
        return Objects.hash(this.balance, this.currency, this.received, this.reserved);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BalanceMutation {\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    received: ").append(this.toIndentedString(this.received)).append("\n");
        sb.append("    reserved: ").append(this.toIndentedString(this.reserved)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static BalanceMutation fromJson(String jsonString) throws JsonProcessingException {
        return (BalanceMutation)JSON.getMapper().readValue(jsonString, BalanceMutation.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

