/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.storedvalue;

import com.adyen.model.storedvalue.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"merchantAccount", "originalReference", "reference", "store", "tenderReference", "uniqueTerminalId"})
public class StoredValueVoidRequest {
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_ORIGINAL_REFERENCE = "originalReference";
    private String originalReference;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_STORE = "store";
    private String store;
    public static final String JSON_PROPERTY_TENDER_REFERENCE = "tenderReference";
    private String tenderReference;
    public static final String JSON_PROPERTY_UNIQUE_TERMINAL_ID = "uniqueTerminalId";
    private String uniqueTerminalId;

    public StoredValueVoidRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier, with which you want to process the transaction.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public StoredValueVoidRequest originalReference(String originalReference) {
        this.originalReference = originalReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The original pspReference of the payment to modify.")
    @JsonProperty(value="originalReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOriginalReference() {
        return this.originalReference;
    }

    @JsonProperty(value="originalReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOriginalReference(String originalReference) {
        this.originalReference = originalReference;
    }

    public StoredValueVoidRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the payment modification. This reference is visible in Customer Area and in reports. Maximum length: 80 characters.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public StoredValueVoidRequest store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(value="The physical store, for which this payment is processed.")
    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStore() {
        return this.store;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStore(String store) {
        this.store = store;
    }

    public StoredValueVoidRequest tenderReference(String tenderReference) {
        this.tenderReference = tenderReference;
        return this;
    }

    @ApiModelProperty(value="The reference of the tender.")
    @JsonProperty(value="tenderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTenderReference() {
        return this.tenderReference;
    }

    @JsonProperty(value="tenderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTenderReference(String tenderReference) {
        this.tenderReference = tenderReference;
    }

    public StoredValueVoidRequest uniqueTerminalId(String uniqueTerminalId) {
        this.uniqueTerminalId = uniqueTerminalId;
        return this;
    }

    @ApiModelProperty(value="The unique ID of a POS terminal.")
    @JsonProperty(value="uniqueTerminalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUniqueTerminalId() {
        return this.uniqueTerminalId;
    }

    @JsonProperty(value="uniqueTerminalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUniqueTerminalId(String uniqueTerminalId) {
        this.uniqueTerminalId = uniqueTerminalId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredValueVoidRequest storedValueVoidRequest = (StoredValueVoidRequest)o;
        return Objects.equals(this.merchantAccount, storedValueVoidRequest.merchantAccount) && Objects.equals(this.originalReference, storedValueVoidRequest.originalReference) && Objects.equals(this.reference, storedValueVoidRequest.reference) && Objects.equals(this.store, storedValueVoidRequest.store) && Objects.equals(this.tenderReference, storedValueVoidRequest.tenderReference) && Objects.equals(this.uniqueTerminalId, storedValueVoidRequest.uniqueTerminalId);
    }

    public int hashCode() {
        return Objects.hash(this.merchantAccount, this.originalReference, this.reference, this.store, this.tenderReference, this.uniqueTerminalId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoredValueVoidRequest {\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    originalReference: ").append(this.toIndentedString(this.originalReference)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    tenderReference: ").append(this.toIndentedString(this.tenderReference)).append("\n");
        sb.append("    uniqueTerminalId: ").append(this.toIndentedString(this.uniqueTerminalId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static StoredValueVoidRequest fromJson(String jsonString) throws JsonProcessingException {
        return (StoredValueVoidRequest)JSON.getMapper().readValue(jsonString, StoredValueVoidRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

