/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayfund;

import com.adyen.model.marketpayfund.AccountDetailBalance;
import com.adyen.model.marketpayfund.DetailBalance;
import com.adyen.model.marketpayfund.ErrorFieldType;
import com.adyen.model.marketpayfund.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"balancePerAccount", "invalidFields", "pspReference", "resultCode", "totalBalance"})
public class AccountHolderBalanceResponse {
    public static final String JSON_PROPERTY_BALANCE_PER_ACCOUNT = "balancePerAccount";
    private List<AccountDetailBalance> balancePerAccount = null;
    public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
    private List<ErrorFieldType> invalidFields = null;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
    private String resultCode;
    public static final String JSON_PROPERTY_TOTAL_BALANCE = "totalBalance";
    private DetailBalance totalBalance;

    public AccountHolderBalanceResponse balancePerAccount(List<AccountDetailBalance> balancePerAccount) {
        this.balancePerAccount = balancePerAccount;
        return this;
    }

    public AccountHolderBalanceResponse addBalancePerAccountItem(AccountDetailBalance balancePerAccountItem) {
        if (this.balancePerAccount == null) {
            this.balancePerAccount = new ArrayList<AccountDetailBalance>();
        }
        this.balancePerAccount.add(balancePerAccountItem);
        return this;
    }

    @ApiModelProperty(value="A list of each account and their balances.")
    @JsonProperty(value="balancePerAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AccountDetailBalance> getBalancePerAccount() {
        return this.balancePerAccount;
    }

    @JsonProperty(value="balancePerAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalancePerAccount(List<AccountDetailBalance> balancePerAccount) {
        this.balancePerAccount = balancePerAccount;
    }

    public AccountHolderBalanceResponse invalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
        return this;
    }

    public AccountHolderBalanceResponse addInvalidFieldsItem(ErrorFieldType invalidFieldsItem) {
        if (this.invalidFields == null) {
            this.invalidFields = new ArrayList<ErrorFieldType>();
        }
        this.invalidFields.add(invalidFieldsItem);
        return this;
    }

    @ApiModelProperty(value="Contains field validation errors that would prevent requests from being processed.")
    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ErrorFieldType> getInvalidFields() {
        return this.invalidFields;
    }

    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
    }

    public AccountHolderBalanceResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(value="The reference of a request. Can be used to uniquely identify the request.")
    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public AccountHolderBalanceResponse resultCode(String resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    @ApiModelProperty(value="The result code.")
    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResultCode() {
        return this.resultCode;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public AccountHolderBalanceResponse totalBalance(DetailBalance totalBalance) {
        this.totalBalance = totalBalance;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="totalBalance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DetailBalance getTotalBalance() {
        return this.totalBalance;
    }

    @JsonProperty(value="totalBalance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalBalance(DetailBalance totalBalance) {
        this.totalBalance = totalBalance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHolderBalanceResponse accountHolderBalanceResponse = (AccountHolderBalanceResponse)o;
        return Objects.equals(this.balancePerAccount, accountHolderBalanceResponse.balancePerAccount) && Objects.equals(this.invalidFields, accountHolderBalanceResponse.invalidFields) && Objects.equals(this.pspReference, accountHolderBalanceResponse.pspReference) && Objects.equals(this.resultCode, accountHolderBalanceResponse.resultCode) && Objects.equals(this.totalBalance, accountHolderBalanceResponse.totalBalance);
    }

    public int hashCode() {
        return Objects.hash(this.balancePerAccount, this.invalidFields, this.pspReference, this.resultCode, this.totalBalance);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountHolderBalanceResponse {\n");
        sb.append("    balancePerAccount: ").append(this.toIndentedString(this.balancePerAccount)).append("\n");
        sb.append("    invalidFields: ").append(this.toIndentedString(this.invalidFields)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString(this.resultCode)).append("\n");
        sb.append("    totalBalance: ").append(this.toIndentedString(this.totalBalance)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AccountHolderBalanceResponse fromJson(String jsonString) throws JsonProcessingException {
        return (AccountHolderBalanceResponse)JSON.getMapper().readValue(jsonString, AccountHolderBalanceResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

