/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"doingBusinessAsName", "type"})
public class TransactionDescriptionInfo {
    public static final String JSON_PROPERTY_DOING_BUSINESS_AS_NAME = "doingBusinessAsName";
    private String doingBusinessAsName;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public TransactionDescriptionInfo doingBusinessAsName(String doingBusinessAsName) {
        this.doingBusinessAsName = doingBusinessAsName;
        return this;
    }

    @ApiModelProperty(value="The text to be shown on the shopper's bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , ' _ - ? + * /_**.")
    @JsonProperty(value="doingBusinessAsName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDoingBusinessAsName() {
        return this.doingBusinessAsName;
    }

    @JsonProperty(value="doingBusinessAsName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDoingBusinessAsName(String doingBusinessAsName) {
        this.doingBusinessAsName = doingBusinessAsName;
    }

    public TransactionDescriptionInfo type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of transaction description you want to use: - **fixed**: The transaction description set in this request is used for all payments with this payment method. - **append**: The transaction description set in this request is used as a base for all payments with this payment method. The [transaction description set in the request to process the payment](https://docs.adyen.com/api-explorer/Checkout/70/post/sessions#request-shopperStatement) is appended to this base description. Note that if the combined length exceeds 22 characters, banks may truncate the string. - **dynamic**: Only the [transaction description set in the request to process the payment](https://docs.adyen.com/api-explorer/Checkout/70/post/sessions#request-shopperStatement) is used for payments with this payment method.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionDescriptionInfo transactionDescriptionInfo = (TransactionDescriptionInfo)o;
        return Objects.equals(this.doingBusinessAsName, transactionDescriptionInfo.doingBusinessAsName) && Objects.equals((Object)this.type, (Object)transactionDescriptionInfo.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.doingBusinessAsName, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionDescriptionInfo {\n");
        sb.append("    doingBusinessAsName: ").append(this.toIndentedString(this.doingBusinessAsName)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TransactionDescriptionInfo fromJson(String jsonString) throws JsonProcessingException {
        return (TransactionDescriptionInfo)JSON.getMapper().readValue(jsonString, TransactionDescriptionInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        APPEND("append"),
        DYNAMIC("dynamic"),
        FIXED("fixed");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

