/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.Address;
import com.adyen.model.legalentitymanagement.BirthData;
import com.adyen.model.legalentitymanagement.IdentificationData;
import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.Name;
import com.adyen.model.legalentitymanagement.PhoneNumber;
import com.adyen.model.legalentitymanagement.TaxInformation;
import com.adyen.model.legalentitymanagement.WebData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"birthData", "email", "identificationData", "name", "nationality", "phone", "residentialAddress", "taxInformation", "webData"})
public class Individual {
    public static final String JSON_PROPERTY_BIRTH_DATA = "birthData";
    private BirthData birthData;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_IDENTIFICATION_DATA = "identificationData";
    private IdentificationData identificationData;
    public static final String JSON_PROPERTY_NAME = "name";
    private Name name;
    public static final String JSON_PROPERTY_NATIONALITY = "nationality";
    private String nationality;
    public static final String JSON_PROPERTY_PHONE = "phone";
    private PhoneNumber phone;
    public static final String JSON_PROPERTY_RESIDENTIAL_ADDRESS = "residentialAddress";
    private Address residentialAddress;
    public static final String JSON_PROPERTY_TAX_INFORMATION = "taxInformation";
    private List<TaxInformation> taxInformation = null;
    public static final String JSON_PROPERTY_WEB_DATA = "webData";
    private WebData webData;

    public Individual birthData(BirthData birthData) {
        this.birthData = birthData;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="birthData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BirthData getBirthData() {
        return this.birthData;
    }

    @JsonProperty(value="birthData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBirthData(BirthData birthData) {
        this.birthData = birthData;
    }

    public Individual email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The email address of the legal entity.")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(String email) {
        this.email = email;
    }

    public Individual identificationData(IdentificationData identificationData) {
        this.identificationData = identificationData;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="identificationData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IdentificationData getIdentificationData() {
        return this.identificationData;
    }

    @JsonProperty(value="identificationData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentificationData(IdentificationData identificationData) {
        this.identificationData = identificationData;
    }

    public Individual name(Name name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Name getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(Name name) {
        this.name = name;
    }

    public Individual nationality(String nationality) {
        this.nationality = nationality;
        return this;
    }

    @ApiModelProperty(value="The individual's nationality.")
    @JsonProperty(value="nationality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNationality() {
        return this.nationality;
    }

    @JsonProperty(value="nationality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public Individual phone(PhoneNumber phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="phone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PhoneNumber getPhone() {
        return this.phone;
    }

    @JsonProperty(value="phone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhone(PhoneNumber phone) {
        this.phone = phone;
    }

    public Individual residentialAddress(Address residentialAddress) {
        this.residentialAddress = residentialAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="residentialAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getResidentialAddress() {
        return this.residentialAddress;
    }

    @JsonProperty(value="residentialAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResidentialAddress(Address residentialAddress) {
        this.residentialAddress = residentialAddress;
    }

    public Individual taxInformation(List<TaxInformation> taxInformation) {
        this.taxInformation = taxInformation;
        return this;
    }

    public Individual addTaxInformationItem(TaxInformation taxInformationItem) {
        if (this.taxInformation == null) {
            this.taxInformation = new ArrayList<TaxInformation>();
        }
        this.taxInformation.add(taxInformationItem);
        return this;
    }

    @ApiModelProperty(value="The tax information of the individual.")
    @JsonProperty(value="taxInformation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TaxInformation> getTaxInformation() {
        return this.taxInformation;
    }

    @JsonProperty(value="taxInformation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaxInformation(List<TaxInformation> taxInformation) {
        this.taxInformation = taxInformation;
    }

    public Individual webData(WebData webData) {
        this.webData = webData;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="webData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WebData getWebData() {
        return this.webData;
    }

    @JsonProperty(value="webData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebData(WebData webData) {
        this.webData = webData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Individual individual = (Individual)o;
        return Objects.equals(this.birthData, individual.birthData) && Objects.equals(this.email, individual.email) && Objects.equals(this.identificationData, individual.identificationData) && Objects.equals(this.name, individual.name) && Objects.equals(this.nationality, individual.nationality) && Objects.equals(this.phone, individual.phone) && Objects.equals(this.residentialAddress, individual.residentialAddress) && Objects.equals(this.taxInformation, individual.taxInformation) && Objects.equals(this.webData, individual.webData);
    }

    public int hashCode() {
        return Objects.hash(this.birthData, this.email, this.identificationData, this.name, this.nationality, this.phone, this.residentialAddress, this.taxInformation, this.webData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Individual {\n");
        sb.append("    birthData: ").append(this.toIndentedString(this.birthData)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    identificationData: ").append(this.toIndentedString(this.identificationData)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nationality: ").append(this.toIndentedString(this.nationality)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    residentialAddress: ").append(this.toIndentedString(this.residentialAddress)).append("\n");
        sb.append("    taxInformation: ").append(this.toIndentedString(this.taxInformation)).append("\n");
        sb.append("    webData: ").append(this.toIndentedString(this.webData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Individual fromJson(String jsonString) throws JsonProcessingException {
        return (Individual)JSON.getMapper().readValue(jsonString, Individual.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

