/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.recurring;

import com.adyen.model.recurring.JSON;
import com.adyen.model.recurring.PermitRestriction;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"partnerId", "profileReference", "restriction", "resultKey", "validTillDate"})
public class Permit {
    public static final String JSON_PROPERTY_PARTNER_ID = "partnerId";
    private String partnerId;
    public static final String JSON_PROPERTY_PROFILE_REFERENCE = "profileReference";
    private String profileReference;
    public static final String JSON_PROPERTY_RESTRICTION = "restriction";
    private PermitRestriction restriction;
    public static final String JSON_PROPERTY_RESULT_KEY = "resultKey";
    private String resultKey;
    public static final String JSON_PROPERTY_VALID_TILL_DATE = "validTillDate";
    private OffsetDateTime validTillDate;

    public Permit partnerId(String partnerId) {
        this.partnerId = partnerId;
        return this;
    }

    @ApiModelProperty(value="Partner ID (when using the permit-per-partner token sharing model).")
    @JsonProperty(value="partnerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPartnerId() {
        return this.partnerId;
    }

    @JsonProperty(value="partnerId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public Permit profileReference(String profileReference) {
        this.profileReference = profileReference;
        return this;
    }

    @ApiModelProperty(value="The profile to apply to this permit (when using the shared permits model).")
    @JsonProperty(value="profileReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProfileReference() {
        return this.profileReference;
    }

    @JsonProperty(value="profileReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfileReference(String profileReference) {
        this.profileReference = profileReference;
    }

    public Permit restriction(PermitRestriction restriction) {
        this.restriction = restriction;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="restriction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PermitRestriction getRestriction() {
        return this.restriction;
    }

    @JsonProperty(value="restriction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRestriction(PermitRestriction restriction) {
        this.restriction = restriction;
    }

    public Permit resultKey(String resultKey) {
        this.resultKey = resultKey;
        return this;
    }

    @ApiModelProperty(value="The key to link permit requests to permit results.")
    @JsonProperty(value="resultKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResultKey() {
        return this.resultKey;
    }

    @JsonProperty(value="resultKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResultKey(String resultKey) {
        this.resultKey = resultKey;
    }

    public Permit validTillDate(OffsetDateTime validTillDate) {
        this.validTillDate = validTillDate;
        return this;
    }

    @ApiModelProperty(value="The expiry date for this permit.")
    @JsonProperty(value="validTillDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getValidTillDate() {
        return this.validTillDate;
    }

    @JsonProperty(value="validTillDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValidTillDate(OffsetDateTime validTillDate) {
        this.validTillDate = validTillDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Permit permit = (Permit)o;
        return Objects.equals(this.partnerId, permit.partnerId) && Objects.equals(this.profileReference, permit.profileReference) && Objects.equals(this.restriction, permit.restriction) && Objects.equals(this.resultKey, permit.resultKey) && Objects.equals(this.validTillDate, permit.validTillDate);
    }

    public int hashCode() {
        return Objects.hash(this.partnerId, this.profileReference, this.restriction, this.resultKey, this.validTillDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Permit {\n");
        sb.append("    partnerId: ").append(this.toIndentedString(this.partnerId)).append("\n");
        sb.append("    profileReference: ").append(this.toIndentedString(this.profileReference)).append("\n");
        sb.append("    restriction: ").append(this.toIndentedString(this.restriction)).append("\n");
        sb.append("    resultKey: ").append(this.toIndentedString(this.resultKey)).append("\n");
        sb.append("    validTillDate: ").append(this.toIndentedString(this.validTillDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Permit fromJson(String jsonString) throws JsonProcessingException {
        return (Permit)JSON.getMapper().readValue(jsonString, Permit.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

