/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"companyId", "inventory", "merchantId", "storeId"})
public class TerminalReassignmentRequest {
    public static final String JSON_PROPERTY_COMPANY_ID = "companyId";
    private String companyId;
    public static final String JSON_PROPERTY_INVENTORY = "inventory";
    private Boolean inventory;
    public static final String JSON_PROPERTY_MERCHANT_ID = "merchantId";
    private String merchantId;
    public static final String JSON_PROPERTY_STORE_ID = "storeId";
    private String storeId;

    public TerminalReassignmentRequest companyId(String companyId) {
        this.companyId = companyId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the company account to which the terminal is reassigned.")
    @JsonProperty(value="companyId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="companyId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public TerminalReassignmentRequest inventory(Boolean inventory) {
        this.inventory = inventory;
        return this;
    }

    @ApiModelProperty(value="Must be specified when reassigning terminals to a merchant account:  - If set to **true**, reassigns terminals to the inventory of the merchant account and the terminals cannot process transactions.  - If set to **false**, reassigns terminals directly to the merchant account and the terminals can process transactions.")
    @JsonProperty(value="inventory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getInventory() {
        return this.inventory;
    }

    @JsonProperty(value="inventory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInventory(Boolean inventory) {
        this.inventory = inventory;
    }

    public TerminalReassignmentRequest merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the merchant account to which the terminal is reassigned. When reassigning terminals to a merchant account, you must specify the `inventory` field.")
    @JsonProperty(value="merchantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantId() {
        return this.merchantId;
    }

    @JsonProperty(value="merchantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public TerminalReassignmentRequest storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the store to which the terminal is reassigned.")
    @JsonProperty(value="storeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoreId() {
        return this.storeId;
    }

    @JsonProperty(value="storeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TerminalReassignmentRequest terminalReassignmentRequest = (TerminalReassignmentRequest)o;
        return Objects.equals(this.companyId, terminalReassignmentRequest.companyId) && Objects.equals(this.inventory, terminalReassignmentRequest.inventory) && Objects.equals(this.merchantId, terminalReassignmentRequest.merchantId) && Objects.equals(this.storeId, terminalReassignmentRequest.storeId);
    }

    public int hashCode() {
        return Objects.hash(this.companyId, this.inventory, this.merchantId, this.storeId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TerminalReassignmentRequest {\n");
        sb.append("    companyId: ").append(this.toIndentedString(this.companyId)).append("\n");
        sb.append("    inventory: ").append(this.toIndentedString(this.inventory)).append("\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("    storeId: ").append(this.toIndentedString(this.storeId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TerminalReassignmentRequest fromJson(String jsonString) throws JsonProcessingException {
        return (TerminalReassignmentRequest)JSON.getMapper().readValue(jsonString, TerminalReassignmentRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

