/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"balanceAccountId", "splitConfigurationId"})
public class StoreSplitConfiguration {
    public static final String JSON_PROPERTY_BALANCE_ACCOUNT_ID = "balanceAccountId";
    private String balanceAccountId;
    public static final String JSON_PROPERTY_SPLIT_CONFIGURATION_ID = "splitConfigurationId";
    private String splitConfigurationId;

    public StoreSplitConfiguration balanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
        return this;
    }

    @ApiModelProperty(value="The [unique identifier of the balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/get/balanceAccounts/{id}__queryParam_id) to which the split amount must be booked, depending on the defined [split logic](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/_merchantId_/splitConfigurations#request-rules-splitLogic).")
    @JsonProperty(value="balanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalanceAccountId() {
        return this.balanceAccountId;
    }

    @JsonProperty(value="balanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
    }

    public StoreSplitConfiguration splitConfigurationId(String splitConfigurationId) {
        this.splitConfigurationId = splitConfigurationId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the [split configuration profile](https://docs.adyen.com/platforms/automatic-split-configuration/create-split-configuration/).")
    @JsonProperty(value="splitConfigurationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSplitConfigurationId() {
        return this.splitConfigurationId;
    }

    @JsonProperty(value="splitConfigurationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplitConfigurationId(String splitConfigurationId) {
        this.splitConfigurationId = splitConfigurationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreSplitConfiguration storeSplitConfiguration = (StoreSplitConfiguration)o;
        return Objects.equals(this.balanceAccountId, storeSplitConfiguration.balanceAccountId) && Objects.equals(this.splitConfigurationId, storeSplitConfiguration.splitConfigurationId);
    }

    public int hashCode() {
        return Objects.hash(this.balanceAccountId, this.splitConfigurationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoreSplitConfiguration {\n");
        sb.append("    balanceAccountId: ").append(this.toIndentedString(this.balanceAccountId)).append("\n");
        sb.append("    splitConfigurationId: ").append(this.toIndentedString(this.splitConfigurationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static StoreSplitConfiguration fromJson(String jsonString) throws JsonProcessingException {
        return (StoreSplitConfiguration)JSON.getMapper().readValue(jsonString, StoreSplitConfiguration.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

