/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"enabled", "enabledFromDate", "transferInstrumentId"})
public class PayoutSettingsRequest {
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;
    public static final String JSON_PROPERTY_ENABLED_FROM_DATE = "enabledFromDate";
    private String enabledFromDate;
    public static final String JSON_PROPERTY_TRANSFER_INSTRUMENT_ID = "transferInstrumentId";
    private String transferInstrumentId;

    public PayoutSettingsRequest enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="Indicates if payouts to this bank account are enabled. Default: **true**.  To receive payouts into this bank account, both `enabled` and `allowed` must be **true**.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public PayoutSettingsRequest enabledFromDate(String enabledFromDate) {
        this.enabledFromDate = enabledFromDate;
        return this;
    }

    @ApiModelProperty(value="The date when Adyen starts paying out to this bank account.  Format: [ISO 8601](https://www.w3.org/TR/NOTE-datetime), for example, **2019-11-23T12:25:28Z** or **2020-05-27T20:25:28+08:00**.  If not specified, the `enabled` field indicates if payouts are enabled for this bank account.  If a date is specified and:  * `enabled`: **true**, payouts are enabled starting the specified date. * `enabled`: **false**, payouts are disabled until the specified date. On the specified date, `enabled` changes to **true** and this field is reset to **null**.")
    @JsonProperty(value="enabledFromDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEnabledFromDate() {
        return this.enabledFromDate;
    }

    @JsonProperty(value="enabledFromDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabledFromDate(String enabledFromDate) {
        this.enabledFromDate = enabledFromDate;
    }

    public PayoutSettingsRequest transferInstrumentId(String transferInstrumentId) {
        this.transferInstrumentId = transferInstrumentId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments) that contains the details of the bank account.")
    @JsonProperty(value="transferInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTransferInstrumentId() {
        return this.transferInstrumentId;
    }

    @JsonProperty(value="transferInstrumentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransferInstrumentId(String transferInstrumentId) {
        this.transferInstrumentId = transferInstrumentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayoutSettingsRequest payoutSettingsRequest = (PayoutSettingsRequest)o;
        return Objects.equals(this.enabled, payoutSettingsRequest.enabled) && Objects.equals(this.enabledFromDate, payoutSettingsRequest.enabledFromDate) && Objects.equals(this.transferInstrumentId, payoutSettingsRequest.transferInstrumentId);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.enabledFromDate, this.transferInstrumentId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayoutSettingsRequest {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    enabledFromDate: ").append(this.toIndentedString(this.enabledFromDate)).append("\n");
        sb.append("    transferInstrumentId: ").append(this.toIndentedString(this.transferInstrumentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PayoutSettingsRequest fromJson(String jsonString) throws JsonProcessingException {
        return (PayoutSettingsRequest)JSON.getMapper().readValue(jsonString, PayoutSettingsRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

