/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"merchantId", "reuseMerchantId"})
public class GooglePayInfo {
    public static final String JSON_PROPERTY_MERCHANT_ID = "merchantId";
    private String merchantId;
    public static final String JSON_PROPERTY_REUSE_MERCHANT_ID = "reuseMerchantId";
    private Boolean reuseMerchantId;

    public GooglePayInfo merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(required=true, value="Google Pay [Merchant ID](https://support.google.com/paymentscenter/answer/7163092?hl=en). Character length and limitations: 16 alphanumeric characters or 20 numeric characters.")
    @JsonProperty(value="merchantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantId() {
        return this.merchantId;
    }

    @JsonProperty(value="merchantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public GooglePayInfo reuseMerchantId(Boolean reuseMerchantId) {
        this.reuseMerchantId = reuseMerchantId;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the Google Pay Merchant ID is used for several merchant accounts. Default value: **false**.")
    @JsonProperty(value="reuseMerchantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReuseMerchantId() {
        return this.reuseMerchantId;
    }

    @JsonProperty(value="reuseMerchantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReuseMerchantId(Boolean reuseMerchantId) {
        this.reuseMerchantId = reuseMerchantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GooglePayInfo googlePayInfo = (GooglePayInfo)o;
        return Objects.equals(this.merchantId, googlePayInfo.merchantId) && Objects.equals(this.reuseMerchantId, googlePayInfo.reuseMerchantId);
    }

    public int hashCode() {
        return Objects.hash(this.merchantId, this.reuseMerchantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GooglePayInfo {\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("    reuseMerchantId: ").append(this.toIndentedString(this.reuseMerchantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static GooglePayInfo fromJson(String jsonString) throws JsonProcessingException {
        return (GooglePayInfo)JSON.getMapper().readValue(jsonString, GooglePayInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

