/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3;

import flash.localization.LocalizationManager;
import flash.swf.tools.as3.EvaluatorAdapter;
import flex2.compiler.as3.AttributeInfo;
import flex2.compiler.as3.AttributeInfoCache;
import flex2.compiler.as3.SignatureAssertionRuntimeException;
import flex2.compiler.as3.SignatureRules;
import flex2.compiler.as3.reflect.NodeMagic;
import java.util.Iterator;
import java.util.TreeSet;
import macromedia.asc.parser.ApplyTypeExprNode;
import macromedia.asc.parser.ArgumentListNode;
import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.BinaryClassDefNode;
import macromedia.asc.parser.BinaryExpressionNode;
import macromedia.asc.parser.BinaryFunctionDefinitionNode;
import macromedia.asc.parser.BinaryInterfaceDefinitionNode;
import macromedia.asc.parser.BinaryProgramNode;
import macromedia.asc.parser.BoxNode;
import macromedia.asc.parser.BreakStatementNode;
import macromedia.asc.parser.CallExpressionNode;
import macromedia.asc.parser.CaseLabelNode;
import macromedia.asc.parser.CatchClauseNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.ClassNameNode;
import macromedia.asc.parser.CoerceNode;
import macromedia.asc.parser.ConditionalExpressionNode;
import macromedia.asc.parser.ConfigNamespaceDefinitionNode;
import macromedia.asc.parser.ContinueStatementNode;
import macromedia.asc.parser.DefaultXMLNamespaceNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.DeleteExpressionNode;
import macromedia.asc.parser.DoStatementNode;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.EmptyElementNode;
import macromedia.asc.parser.EmptyStatementNode;
import macromedia.asc.parser.ErrorNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.ExpressionStatementNode;
import macromedia.asc.parser.FinallyClauseNode;
import macromedia.asc.parser.ForStatementNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.FunctionNameNode;
import macromedia.asc.parser.FunctionSignatureNode;
import macromedia.asc.parser.GetExpressionNode;
import macromedia.asc.parser.HasNextNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.IfStatementNode;
import macromedia.asc.parser.ImportDirectiveNode;
import macromedia.asc.parser.ImportNode;
import macromedia.asc.parser.IncludeDirectiveNode;
import macromedia.asc.parser.IncrementNode;
import macromedia.asc.parser.InheritanceNode;
import macromedia.asc.parser.InterfaceDefinitionNode;
import macromedia.asc.parser.InvokeNode;
import macromedia.asc.parser.LabeledStatementNode;
import macromedia.asc.parser.ListNode;
import macromedia.asc.parser.LiteralArrayNode;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralFieldNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralObjectNode;
import macromedia.asc.parser.LiteralRegExpNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.LiteralXMLNode;
import macromedia.asc.parser.LoadRegisterNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.parser.NamespaceDefinitionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.PackageIdentifiersNode;
import macromedia.asc.parser.PackageNameNode;
import macromedia.asc.parser.ParameterListNode;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.ParenExpressionNode;
import macromedia.asc.parser.ParenListExpressionNode;
import macromedia.asc.parser.PragmaExpressionNode;
import macromedia.asc.parser.PragmaNode;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.QualifiedExpressionNode;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.parser.RegisterNode;
import macromedia.asc.parser.RestExpressionNode;
import macromedia.asc.parser.RestParameterNode;
import macromedia.asc.parser.ReturnStatementNode;
import macromedia.asc.parser.SetExpressionNode;
import macromedia.asc.parser.StatementListNode;
import macromedia.asc.parser.StoreRegisterNode;
import macromedia.asc.parser.SuperExpressionNode;
import macromedia.asc.parser.SuperStatementNode;
import macromedia.asc.parser.SwitchStatementNode;
import macromedia.asc.parser.ThisExpressionNode;
import macromedia.asc.parser.ThrowStatementNode;
import macromedia.asc.parser.ToObjectNode;
import macromedia.asc.parser.Tokens;
import macromedia.asc.parser.TryStatementNode;
import macromedia.asc.parser.TypeExpressionNode;
import macromedia.asc.parser.TypedIdentifierNode;
import macromedia.asc.parser.UnaryExpressionNode;
import macromedia.asc.parser.UntypedVariableBindingNode;
import macromedia.asc.parser.UseDirectiveNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.parser.WhileStatementNode;
import macromedia.asc.parser.WithStatementNode;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

public class SignatureEvaluator
extends EvaluatorAdapter
implements Tokens {
    public static String NEWLINE;
    private static final boolean DEBUG = false;
    private final StringBuffer out;
    private int indent;
    private final SignatureRules signatureRules;
    private final AttributeInfoCache attributeInfoCache = new AttributeInfoCache();
    private String indentCache;
    private int lastIndent;
    private StringBuffer buffer = new StringBuffer(128);
    private PackageDefinitionNode currentPackage;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SignatureEvaluator() {
        this(8192);
    }

    public SignatureEvaluator(int suggestedBufferSize) {
        this(suggestedBufferSize, new SignatureRules());
    }

    public SignatureEvaluator(int suggestedBufferSize, SignatureRules signatureRules) {
        this.out = new StringBuffer(suggestedBufferSize);
        this.signatureRules = signatureRules;
    }

    public String getSignature() {
        return this.out.toString();
    }

    public String toString() {
        return this.getSignature();
    }

    private String indent() {
        if (!$assertionsDisabled && this.indent < 0) {
            throw new AssertionError();
        }
        if (this.lastIndent != this.indent) {
            this.indentCache = "";
            for (int i = 0; i < this.indent; ++i) {
                this.indentCache = this.indentCache + "    ";
            }
        }
        return this.indentCache;
    }

    private void printLn(Object str) {
        this.out.append(str).append(NEWLINE);
    }

    private StringBuffer print(Object str) {
        this.out.append(str);
        return this.out;
    }

    public String getAndClearBuffer() {
        String string = this.buffer.toString();
        this.buffer = new StringBuffer(128);
        return string;
    }

    private void flushBufferToSignature() {
        this.print(this.getAndClearBuffer());
    }

    private void ASSERT_BUFFER_EMPTY(Node node) {
        SignatureEvaluator.ASSERT(this.buffer.length() == 0, "Sanity Failed: Buffer is not empty.", node);
    }

    private static void ASSERT_SANITY(boolean expr, Node node) {
        SignatureEvaluator.ASSERT(expr, "Sanity Failed", node);
    }

    private static void UNTESTED_CODEPATH(Node node) {
        SignatureEvaluator.ASSERT(false, "Untested Codepath", node);
    }

    private static void UNREACHABLE_CODEPATH(Node node) {
        SignatureEvaluator.ASSERT(false, "Unreachable Codepath", node);
    }

    private static void UNIMPLEMENTED_CODEPATH(Node node) {
        SignatureEvaluator.ASSERT(false, "Unimplemented Codepath", node);
    }

    private static void ASSERT(boolean expr, String exn, Node node) {
        if (!expr) {
            throw new SignatureAssertionRuntimeException(exn, node);
        }
    }

    public boolean checkFeature(Context cx, Node node) {
        boolean result = true;
        if (node instanceof DefinitionNode) {
            AttributeInfo attInfo = this.attributeInfoCache.getAttributeInfo((DefinitionNode)node);
            if (node instanceof FunctionDefinitionNode) {
                boolean bl;
                if (attInfo.isPublic) {
                    this.signatureRules.getClass();
                }
                if (!attInfo.isPrivate) {
                    if (attInfo.isProtected) {
                        this.signatureRules.getClass();
                    }
                    if (attInfo.isUser) {
                        this.signatureRules.getClass();
                    }
                    if (attInfo.isInternal) {
                        this.signatureRules.getClass();
                    }
                    bl = true;
                } else {
                    this.signatureRules.getClass();
                    bl = false;
                }
                result = bl;
            } else if (node instanceof VariableDefinitionNode) {
                boolean bl;
                if (attInfo.isPublic) {
                    this.signatureRules.getClass();
                }
                if (!attInfo.isPrivate) {
                    if (attInfo.isProtected) {
                        this.signatureRules.getClass();
                    }
                    if (attInfo.isUser) {
                        this.signatureRules.getClass();
                    }
                    if (attInfo.isInternal) {
                        this.signatureRules.getClass();
                    }
                    bl = true;
                } else {
                    this.signatureRules.getClass();
                    bl = false;
                }
                result = bl;
            } else if (node instanceof ImportDirectiveNode) {
                this.signatureRules.getClass();
                result = true;
            } else if (node instanceof ClassDefinitionNode) {
                this.signatureRules.getClass();
                result = true;
            } else if (node instanceof InterfaceDefinitionNode) {
                this.signatureRules.getClass();
                result = true;
            } else if (node instanceof UseDirectiveNode) {
                this.signatureRules.getClass();
                result = true;
            }
        } else if (node instanceof MetaDataNode) {
            this.signatureRules.getClass();
            result = this.checkFeature(cx, (Node)((MetaDataNode)node).def);
        }
        return result;
    }

    public Value evaluate(Context unused_cx, ProgramNode node) {
        this.ASSERT_BUFFER_EMPTY((Node)node);
        Context cx = node.cx;
        SignatureEvaluator.ASSERT_SANITY(node.imports.isEmpty(), (Node)node);
        SignatureEvaluator.ASSERT_SANITY(node.pkgdefs != null, (Node)node);
        SignatureEvaluator.ASSERT_SANITY(node.pkgdefs.size() > 0, (Node)node);
        PackageDefinitionNode mainPackage = (PackageDefinitionNode)node.pkgdefs.first();
        if (mainPackage.statements != null) {
            ++this.indent;
            mainPackage.statements.evaluate(cx, (Evaluator)this);
            this.ASSERT_BUFFER_EMPTY((Node)node);
            --this.indent;
        }
        SignatureEvaluator.ASSERT_SANITY(node.clsdefs == null, (Node)node);
        SignatureEvaluator.ASSERT_SANITY(node.fexprs == null, (Node)node);
        this.ASSERT_BUFFER_EMPTY((Node)node);
        return null;
    }

    public Value evaluate(Context unused_cx, ClassDefinitionNode node) {
        this.ASSERT_BUFFER_EMPTY((Node)node);
        Context cx = node.cx;
        this.buffer.append(this.indent());
        if (node.attrs != null) {
            node.attrs.evaluate(cx, (Evaluator)this);
        }
        SignatureEvaluator.ASSERT_SANITY(node.name != null, (Node)node);
        SignatureEvaluator.ASSERT_SANITY(node.name.name != null, (Node)node);
        this.buffer.append("class ").append(NodeMagic.getUnqualifiedClassName(node));
        if (node.baseclass != null) {
            this.buffer.append(" extends ");
            node.baseclass.evaluate(cx, (Evaluator)this);
        }
        if (node.interfaces != null) {
            this.buffer.append(" implements ");
            this.evaluateSorted(cx, node.interfaces);
        }
        this.buffer.append(NEWLINE).append(this.indent()).append("{").append(NEWLINE);
        this.flushBufferToSignature();
        SignatureEvaluator.ASSERT_SANITY(node.fexprs == null, (Node)node);
        SignatureEvaluator.ASSERT_SANITY(node.staticfexprs == null, (Node)node);
        SignatureEvaluator.ASSERT_SANITY(node.instanceinits == null, (Node)node);
        if (node.statements != null) {
            ++this.indent;
            node.statements.evaluate(cx, (Evaluator)this);
            this.ASSERT_BUFFER_EMPTY((Node)node);
            --this.indent;
        }
        this.buffer.append(this.indent()).append("}").append(NEWLINE);
        this.flushBufferToSignature();
        this.ASSERT_BUFFER_EMPTY((Node)node);
        return null;
    }

    public Value evaluate(Context cx, InterfaceDefinitionNode node) {
        this.ASSERT_BUFFER_EMPTY((Node)node);
        this.buffer.append(this.indent());
        if (node.attrs != null) {
            node.attrs.evaluate(cx, (Evaluator)this);
        }
        SignatureEvaluator.ASSERT_SANITY(node.name != null, (Node)node);
        SignatureEvaluator.ASSERT_SANITY(node.name.name != null, (Node)node);
        this.buffer.append("interface ").append(NodeMagic.getUnqualifiedClassName((ClassDefinitionNode)node));
        if (node.interfaces != null) {
            this.buffer.append(" extends ");
            this.evaluateSorted(cx, node.interfaces);
        }
        SignatureEvaluator.ASSERT_SANITY(node.baseclass == null, (Node)node);
        this.buffer.append(NEWLINE).append(this.indent()).append("{").append(NEWLINE);
        this.flushBufferToSignature();
        if (node.statements != null) {
            ++this.indent;
            node.statements.evaluate(cx, (Evaluator)this);
            this.ASSERT_BUFFER_EMPTY((Node)node);
            --this.indent;
        }
        this.buffer.append(this.indent()).append("}").append(NEWLINE);
        this.flushBufferToSignature();
        this.ASSERT_BUFFER_EMPTY((Node)node);
        return null;
    }

    public Value evaluate(Context unused_cx, FunctionDefinitionNode node) {
        this.ASSERT_BUFFER_EMPTY((Node)node);
        Context cx = node.cx;
        TreeSet sortedAttributeSet = NodeMagic.getSortedAttributes(node.attrs);
        if (node.attrs == null || this.attributeInfoCache.getAttributeInfo((DefinitionNode)node).isInternal) {
            sortedAttributeSet.add("internal");
        }
        this.buffer.append(this.indent()).append(NodeMagic.setToString(sortedAttributeSet, " ")).append(" ").append("function ");
        if (NodeMagic.functionIsGetter(node)) {
            this.buffer.append("get ");
        } else if (NodeMagic.functionIsSetter(node)) {
            this.buffer.append("set ");
        }
        SignatureEvaluator.ASSERT_SANITY(node.name != null, (Node)node);
        SignatureEvaluator.ASSERT_SANITY(node.name.identifier != null, (Node)node);
        this.buffer.append(NodeMagic.getUnqualifiedFunctionName(node));
        SignatureEvaluator.ASSERT_SANITY(node.fexpr != null, (Node)node);
        this.buffer.append("(");
        if (NodeMagic.getFunctionParamCount(node) > 0) {
            Iterator iter = node.fexpr.signature.parameter.items.iterator();
            while (iter.hasNext()) {
                ParameterNode param = (ParameterNode)iter.next();
                SignatureEvaluator.ASSERT_SANITY(param.kind == -112, (Node)node);
                if (param instanceof RestParameterNode) {
                    this.buffer.append("...");
                    continue;
                }
                if (param.type != null) {
                    param.type.evaluate(cx, (Evaluator)this);
                } else if (!param.no_anno) {
                    this.buffer.append("*");
                }
                if (param.init != null) {
                    this.signatureRules.getClass();
                    this.buffer.append("=...");
                }
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
        this.buffer.append(")");
        if (node.fexpr.signature.void_anno) {
            this.buffer.append(":void");
        } else if (!node.fexpr.signature.no_anno) {
            if (node.fexpr.signature.result != null) {
                this.buffer.append(":");
                node.fexpr.signature.result.evaluate(cx, (Evaluator)this);
                SignatureEvaluator.ASSERT_SANITY(this.buffer.charAt(this.buffer.length() - 1) != ':', (Node)node);
            } else {
                this.buffer.append(":").append("*");
            }
        }
        this.buffer.append(NEWLINE);
        this.flushBufferToSignature();
        SignatureEvaluator.ASSERT_SANITY(node.fexpr.def == node, (Node)node);
        this.ASSERT_BUFFER_EMPTY((Node)node);
        return null;
    }

    public Value evaluate(Context cx, VariableDefinitionNode node) {
        this.ASSERT_BUFFER_EMPTY((Node)node);
        TreeSet sortedAttributeSet = NodeMagic.getSortedAttributes(node.attrs);
        if (node.attrs == null || this.attributeInfoCache.getAttributeInfo((DefinitionNode)node).isInternal) {
            sortedAttributeSet.add("internal");
        }
        String kind = node.kind == -65 ? "const " : (node.kind == -112 ? "var " : null);
        SignatureEvaluator.ASSERT_SANITY(kind != null, (Node)node);
        Iterator iter = node.list.items.iterator();
        while (iter.hasNext()) {
            VariableBindingNode variableBinding = (VariableBindingNode)iter.next();
            this.buffer.append(this.indent()).append(NodeMagic.setToString(sortedAttributeSet, " ")).append(" ").append(kind);
            this.buffer.append(variableBinding.variable.identifier.name);
            if (!variableBinding.variable.no_anno) {
                this.buffer.append(":");
                if (variableBinding.variable.type != null) {
                    variableBinding.variable.type.evaluate(cx, (Evaluator)this);
                } else {
                    this.buffer.append("*");
                }
            }
            if (variableBinding.initializer != null) {
                this.buffer.append("=...");
            }
            this.buffer.append(NEWLINE);
        }
        this.flushBufferToSignature();
        this.ASSERT_BUFFER_EMPTY((Node)node);
        return null;
    }

    public Value evaluate(Context cx, ImportDirectiveNode node) {
        this.ASSERT_BUFFER_EMPTY((Node)node);
        SignatureEvaluator.ASSERT_SANITY(node.attrs == null, (Node)node);
        SignatureEvaluator.ASSERT_SANITY(node.name != null, (Node)node);
        SignatureEvaluator.ASSERT_SANITY(node.name.id.list != null, (Node)node);
        SignatureEvaluator.ASSERT_SANITY(!node.name.id.list.isEmpty(), (Node)node);
        this.buffer.append(this.indent()).append("import ");
        this.buffer.append(NodeMagic.getDottedImportName(node));
        this.buffer.append(NEWLINE);
        this.flushBufferToSignature();
        this.ASSERT_BUFFER_EMPTY((Node)node);
        return null;
    }

    public Value evaluate(Context cx, NamespaceDefinitionNode node) {
        this.ASSERT_BUFFER_EMPTY((Node)node);
        this.buffer.append(this.indent());
        if (node.attrs != null) {
            node.attrs.evaluate(cx, (Evaluator)this);
        }
        this.buffer.append("namespace ");
        if (node.name != null) {
            node.name.evaluate(cx, (Evaluator)this);
        }
        if (node.value != null) {
            this.buffer.append("=");
            node.value.evaluate(cx, (Evaluator)this);
        }
        this.buffer.append(NEWLINE);
        this.flushBufferToSignature();
        this.ASSERT_BUFFER_EMPTY((Node)node);
        return null;
    }

    public Value evaluate(Context cx, ConfigNamespaceDefinitionNode node) {
        return null;
    }

    public Value evaluate(Context cx, PackageDefinitionNode node) {
        this.ASSERT_BUFFER_EMPTY((Node)node);
        SignatureEvaluator.ASSERT_SANITY(node.attrs == null, (Node)node);
        if (this.currentPackage == null) {
            this.currentPackage = node;
            this.buffer.append("package ").append(NodeMagic.getPackageName(node)).append(NEWLINE).append("{").append(NEWLINE);
            this.flushBufferToSignature();
        } else {
            this.currentPackage = null;
            this.printLn("}");
        }
        this.ASSERT_BUFFER_EMPTY((Node)node);
        return null;
    }

    public Value evaluate(Context cx, UseDirectiveNode node) {
        this.ASSERT_BUFFER_EMPTY((Node)node);
        SignatureEvaluator.ASSERT_SANITY(node.attrs == null, (Node)node);
        this.buffer.append(this.indent()).append("use namespace ");
        if (node.expr != null) {
            if (node.expr instanceof ListNode) {
                this.evaluateSorted(cx, (ListNode)node.expr);
            } else {
                node.expr.evaluate(cx, (Evaluator)this);
            }
        }
        this.buffer.append(NEWLINE);
        this.flushBufferToSignature();
        this.ASSERT_BUFFER_EMPTY((Node)node);
        return null;
    }

    public Value evaluate(Context cx, MetaDataNode node) {
        this.ASSERT_BUFFER_EMPTY((Node)node);
        if (node.data != null) {
            new MetaDataEvaluator().evaluate(cx, node);
        }
        SignatureEvaluator.ASSERT_SANITY(node.id != null, (Node)node);
        this.buffer.append(this.indent()).append("[").append(node.id).append(NodeMagic.getSortedMetaDataParamString(node)).append("]").append(NEWLINE);
        this.flushBufferToSignature();
        this.ASSERT_BUFFER_EMPTY((Node)node);
        return null;
    }

    public Value evaluate(Context cx, ExpressionStatementNode node) {
        this.ASSERT_BUFFER_EMPTY((Node)node);
        return null;
    }

    public Value evaluate(Context cx, DefaultXMLNamespaceNode node) {
        return null;
    }

    public Value evaluate(Context cx, TryStatementNode node) {
        return null;
    }

    public Value evaluate(Context cx, CatchClauseNode node) {
        return null;
    }

    public Value evaluate(Context cx, ArgumentListNode node) {
        Iterator iter = node.items.iterator();
        while (iter.hasNext()) {
            Node item = (Node)iter.next();
            item.evaluate(cx, (Evaluator)this);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        return null;
    }

    public Value evaluate(Context cx, ListNode node) {
        Iterator iter = node.items.iterator();
        while (iter.hasNext()) {
            ((Node)iter.next()).evaluate(cx, (Evaluator)this);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        return null;
    }

    public Value evaluateSorted(Context cx, ListNode node) {
        StringBuffer lastBuffer = this.buffer;
        TreeSet<String> sorted = new TreeSet<String>();
        this.buffer = new StringBuffer(128);
        Iterator iter = node.items.iterator();
        while (iter.hasNext()) {
            ((Node)iter.next()).evaluate(cx, (Evaluator)this);
            sorted.add(this.getAndClearBuffer());
        }
        this.buffer = lastBuffer;
        iter = sorted.iterator();
        while (iter.hasNext()) {
            this.buffer.append(iter.next());
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        return null;
    }

    public Value evaluate(Context cx, GetExpressionNode node) {
        if (node.expr != null) {
            if (node.expr instanceof ArgumentListNode) {
                this.buffer.append("[");
                node.expr.evaluate(cx, (Evaluator)this);
                this.buffer.append("]");
            } else {
                node.expr.evaluate(cx, (Evaluator)this);
            }
        }
        return null;
    }

    public Value evaluate(Context cx, QualifiedIdentifierNode node) {
        if (node.qualifier != null) {
            node.qualifier.evaluate(cx, (Evaluator)this);
            this.buffer.append("::");
        }
        this.evaluate(cx, (IdentifierNode)node);
        return null;
    }

    public Value evaluate(Context cx, QualifiedExpressionNode node) {
        this.buffer.append("@");
        this.evaluate(cx, (QualifiedIdentifierNode)node);
        if (node.expr != null) {
            this.buffer.append("[");
            node.expr.evaluate(cx, (Evaluator)this);
            this.buffer.append("]");
        }
        return null;
    }

    public Value evaluate(Context cx, MemberExpressionNode node) {
        if (node.base != null) {
            node.base.evaluate(cx, (Evaluator)this);
            if (node.selector instanceof GetExpressionNode && !(((GetExpressionNode)node.selector).expr instanceof ArgumentListNode)) {
                this.buffer.append(".");
            }
        }
        if (node.selector != null) {
            node.selector.evaluate(cx, (Evaluator)this);
        }
        return null;
    }

    public Value evaluate(Context cx, TypeExpressionNode node) {
        return super.evaluate(cx, node);
    }

    public Value evaluate(Context cx, AttributeListNode node) {
        String attrs = NodeMagic.getSortedAttributeString(node, " ");
        if (attrs.length() > 0) {
            this.buffer.append(attrs).append(" ");
        }
        return null;
    }

    public Value evaluate(Context cx, ApplyTypeExprNode node) {
        if (node.expr != null) {
            node.expr.evaluate(cx, (Evaluator)this);
        }
        this.buffer.append(".<");
        if (node.typeArgs != null) {
            node.typeArgs.evaluate(cx, (Evaluator)this);
        }
        this.buffer.append(">");
        return null;
    }

    public Value evaluate(Context cx, IdentifierNode node) {
        this.buffer.append(node.name);
        return null;
    }

    public Value evaluate(Context cx, LiteralArrayNode node) {
        this.buffer.append("[");
        super.evaluate(cx, node);
        this.buffer.append("]");
        return null;
    }

    public Value evaluate(Context cx, LiteralBooleanNode node) {
        this.buffer.append(node.value);
        return null;
    }

    public Value evaluate(Context cx, LiteralFieldNode node) {
        if (node.name != null) {
            node.name.evaluate(cx, (Evaluator)this);
        }
        if (node.value != null) {
            this.buffer.append(':');
            node.value.evaluate(cx, (Evaluator)this);
        }
        return null;
    }

    public Value evaluate(Context cx, LiteralNullNode node) {
        this.buffer.append("null");
        return null;
    }

    public Value evaluate(Context cx, LiteralNumberNode node) {
        this.buffer.append(node.value);
        return null;
    }

    public Value evaluate(Context cx, LiteralObjectNode node) {
        this.buffer.append('{');
        if (node.fieldlist != null) {
            node.fieldlist.evaluate(cx, (Evaluator)this);
        }
        this.buffer.append('}');
        return null;
    }

    public Value evaluate(Context cx, LiteralRegExpNode node) {
        this.buffer.append(node.value);
        return null;
    }

    public Value evaluate(Context cx, LiteralStringNode node) {
        this.buffer.append(node.value);
        return null;
    }

    public Value evaluate(Context cx, Node node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH(node);
        return null;
    }

    public Value evaluate(Context cx, VariableBindingNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, UntypedVariableBindingNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, TypedIdentifierNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, ParenExpressionNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, ParenListExpressionNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, FunctionSignatureNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, FunctionCommonNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, PackageIdentifiersNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, PackageNameNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, ClassNameNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, FunctionNameNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, ImportNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, ReturnStatementNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, SuperExpressionNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, SuperStatementNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, SwitchStatementNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, ThisExpressionNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, ThrowStatementNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, UnaryExpressionNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, WhileStatementNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, WithStatementNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, DeleteExpressionNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, DoStatementNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, FinallyClauseNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, ForStatementNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, IfStatementNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, IncrementNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, RestParameterNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, BreakStatementNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, CallExpressionNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, CaseLabelNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, ConditionalExpressionNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, ContinueStatementNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, BinaryClassDefNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, BinaryExpressionNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, BinaryFunctionDefinitionNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, BinaryInterfaceDefinitionNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, BinaryProgramNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, HasNextNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, LoadRegisterNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, StoreRegisterNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, RegisterNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, InheritanceNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, InvokeNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, ParameterListNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, ParameterNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, RestExpressionNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, LabeledStatementNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, BoxNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, CoerceNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, ToObjectNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, PragmaNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, PragmaExpressionNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public Value evaluate(Context cx, SetExpressionNode node) {
        SignatureEvaluator.UNREACHABLE_CODEPATH((Node)node);
        return null;
    }

    public void setLocalizationManager(LocalizationManager l10n) {
        super.setLocalizationManager(l10n);
    }

    public Value evaluate(Context cx, DocCommentNode node) {
        return super.evaluate(cx, node);
    }

    public Value evaluate(Context cx, EmptyStatementNode node) {
        return super.evaluate(cx, node);
    }

    public Value evaluate(Context cx, EmptyElementNode node) {
        return super.evaluate(cx, node);
    }

    public Value evaluate(Context cx, IncludeDirectiveNode node) {
        return super.evaluate(cx, node);
    }

    public Value evaluate(Context cx, StatementListNode node) {
        return super.evaluate(cx, node);
    }

    public Value evaluate(Context cx, LiteralXMLNode node) {
        return super.evaluate(cx, node);
    }

    public Value evaluate(Context cx, ErrorNode node) {
        return super.evaluate(cx, node);
    }

    static {
        $assertionsDisabled = !SignatureEvaluator.class.desiredAssertionStatus();
        NEWLINE = System.getProperty("line.separator");
    }
}

