/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3;

import flash.swf.tools.as3.EvaluatorAdapter;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.MultiNameSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import macromedia.asc.parser.BinaryClassDefNode;
import macromedia.asc.parser.BinaryInterfaceDefinitionNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.ImportDirectiveNode;
import macromedia.asc.parser.InterfaceDefinitionNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.MemberExpressionNode;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.PackageIdentifiersNode;
import macromedia.asc.parser.PackageNameNode;
import macromedia.asc.parser.QualifiedIdentifierNode;
import macromedia.asc.semantics.NamespaceValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

public class InheritanceEvaluator
extends EvaluatorAdapter {
    private Set imports;
    private Map qualifiedImports;
    private List inheritanceNames = new ArrayList();
    private MultiNameSet inheritanceMultiNames = new MultiNameSet();
    private List definitionMultiNames = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public InheritanceEvaluator() {
        this.addImport("");
    }

    private void addImport(String importName) {
        if (!$assertionsDisabled && importName == null) {
            throw new AssertionError();
        }
        if (this.imports == null) {
            this.imports = new TreeSet();
        }
        this.imports.add(importName);
    }

    private void addQualifiedImport(String localPart, String namespace) {
        if (!($assertionsDisabled || localPart != null && localPart.length() > 0 && namespace != null)) {
            throw new AssertionError();
        }
        if (this.qualifiedImports == null) {
            this.qualifiedImports = new TreeMap();
        }
        this.qualifiedImports.put(localPart, namespace);
    }

    public Value evaluate(Context context, BinaryInterfaceDefinitionNode binaryInterfaceDefinition) {
        if (binaryInterfaceDefinition.cframe != null && binaryInterfaceDefinition.cframe.name != null && binaryInterfaceDefinition.cframe.name.ns != null && binaryInterfaceDefinition.cframe.name.ns.name.length() > 0) {
            this.addImport(binaryInterfaceDefinition.cframe.name.ns.name);
        }
        return this.evaluateInterface((ClassDefinitionNode)binaryInterfaceDefinition);
    }

    public Value evaluate(Context context, BinaryClassDefNode binaryClassDefinition) {
        if (binaryClassDefinition.cframe != null && binaryClassDefinition.cframe.name != null && binaryClassDefinition.cframe.name.ns != null && binaryClassDefinition.cframe.name.ns.name.length() > 0) {
            this.addImport(binaryClassDefinition.cframe.name.ns.name);
        }
        return this.evaluate(context, (ClassDefinitionNode)binaryClassDefinition);
    }

    public Value evaluate(Context context, ClassDefinitionNode classDefinition) {
        if (classDefinition.pkgdef != null) {
            PackageIdentifiersNode packageIdentifiers;
            this.processImports(classDefinition.pkgdef.statements.items.iterator());
            PackageNameNode packageName = classDefinition.pkgdef.name;
            if (packageName != null && (packageIdentifiers = packageName.id) != null && packageIdentifiers.pkg_part != null) {
                this.definitionMultiNames.add(new MultiName(packageIdentifiers.pkg_part, classDefinition.name.name));
            }
        }
        if (classDefinition.statements != null) {
            this.processImports(classDefinition.statements.items.iterator());
        }
        if (classDefinition.baseclass != null) {
            if (classDefinition.baseclass instanceof MemberExpressionNode) {
                MemberExpressionNode memberExpression = (MemberExpressionNode)classDefinition.baseclass;
                if (memberExpression.selector != null) {
                    IdentifierNode identifier = memberExpression.selector.getIdentifier();
                    String baseClassName = this.toString(identifier);
                    this.inheritanceNames.add(baseClassName);
                }
            } else if (classDefinition.baseclass instanceof LiteralStringNode) {
                String baseClassName = ((LiteralStringNode)classDefinition.baseclass).value;
                this.inheritanceNames.add(baseClassName);
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        } else {
            this.inheritanceNames.add("Object");
        }
        if (classDefinition.interfaces != null) {
            Iterator iterator = classDefinition.interfaces.items.iterator();
            while (iterator.hasNext()) {
                MemberExpressionNode memberExpression = (MemberExpressionNode)iterator.next();
                if (memberExpression.selector == null) continue;
                IdentifierNode identifier = memberExpression.selector.getIdentifier();
                String interfaceName = this.toString(identifier);
                if (identifier.ref != null && identifier.ref.namespaces != null) {
                    NamespaceValue namespaceValue = (NamespaceValue)identifier.ref.namespaces.get(0);
                    if (namespaceValue.name.length() > 0) {
                        this.inheritanceMultiNames.add(new MultiName(namespaceValue.name, interfaceName));
                        continue;
                    }
                    this.inheritanceNames.add(interfaceName);
                    continue;
                }
                this.inheritanceNames.add(interfaceName);
            }
        }
        return null;
    }

    public Value evaluate(Context context, ImportDirectiveNode importDirective) {
        if (importDirective.name.id.def_part.length() == 0) {
            this.addImport(importDirective.name.id.pkg_part);
        } else {
            this.addQualifiedImport(importDirective.name.id.def_part, importDirective.name.id.pkg_part);
        }
        return null;
    }

    public Value evaluate(Context context, InterfaceDefinitionNode interfaceDefinition) {
        return this.evaluateInterface((ClassDefinitionNode)interfaceDefinition);
    }

    public Value evaluate(Context cx, PackageDefinitionNode packageDefinition) {
        PackageIdentifiersNode packageIdentifiers;
        PackageNameNode packageName = packageDefinition.name;
        if (packageName != null && (packageIdentifiers = packageName.id) != null && packageIdentifiers.pkg_part != null) {
            this.addImport(packageIdentifiers.pkg_part);
        }
        return null;
    }

    private Value evaluateInterface(ClassDefinitionNode interfaceDefinition) {
        if (interfaceDefinition.pkgdef != null) {
            PackageIdentifiersNode packageIdentifiers;
            this.processImports(interfaceDefinition.pkgdef.statements.items.iterator());
            PackageNameNode packageName = interfaceDefinition.pkgdef.name;
            if (packageName != null && (packageIdentifiers = packageName.id) != null && packageIdentifiers.pkg_part != null) {
                this.definitionMultiNames.add(new MultiName(packageIdentifiers.pkg_part, interfaceDefinition.name.name));
            }
        }
        if (interfaceDefinition.statements != null) {
            this.processImports(interfaceDefinition.statements.items.iterator());
        }
        if (interfaceDefinition.baseclass != null) {
            if (interfaceDefinition.baseclass instanceof MemberExpressionNode) {
                MemberExpressionNode memberExpression = (MemberExpressionNode)interfaceDefinition.baseclass;
                if (memberExpression.selector != null) {
                    IdentifierNode identifier = memberExpression.selector.getIdentifier();
                    String baseInterfaceName = this.toString(identifier);
                    this.inheritanceNames.add(baseInterfaceName);
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        } else {
            this.inheritanceNames.add("Object");
        }
        if (interfaceDefinition.interfaces != null) {
            Iterator iterator = interfaceDefinition.interfaces.items.iterator();
            while (iterator.hasNext()) {
                MemberExpressionNode memberExpression = (MemberExpressionNode)iterator.next();
                if (memberExpression.selector == null) continue;
                IdentifierNode identifier = memberExpression.selector.getIdentifier();
                String baseInterfaceName = this.toString(identifier);
                if (identifier.ref != null && identifier.ref.namespaces != null) {
                    NamespaceValue namespaceValue = (NamespaceValue)identifier.ref.namespaces.get(0);
                    if (namespaceValue.name.length() > 0) {
                        this.inheritanceMultiNames.add(new MultiName(namespaceValue.name, baseInterfaceName));
                        continue;
                    }
                    this.inheritanceNames.add(baseInterfaceName);
                    continue;
                }
                this.inheritanceNames.add(baseInterfaceName);
            }
        }
        return null;
    }

    public MultiNameSet getInheritance() {
        if (this.inheritanceNames != null) {
            Iterator iterator = this.inheritanceNames.iterator();
            while (iterator.hasNext()) {
                String inheritanceName = (String)iterator.next();
                MultiName inheritanceMultiName = this.getMultiName(inheritanceName);
                this.inheritanceMultiNames.add(inheritanceMultiName);
            }
        }
        Iterator inheritanceIterator = this.inheritanceMultiNames.iterator();
        while (inheritanceIterator.hasNext()) {
            MultiName inheritanceMultiName = (MultiName)inheritanceIterator.next();
            String[] namespaces = inheritanceMultiName.getNamespace();
            Iterator definitionIterator = this.definitionMultiNames.iterator();
            while (definitionIterator.hasNext()) {
                MultiName definitionMultiName = (MultiName)definitionIterator.next();
                String namespace = definitionMultiName.getNamespace()[0];
                if (!inheritanceMultiName.getLocalPart().equals(definitionMultiName.getLocalPart())) continue;
                for (int i = 0; i < inheritanceMultiName.namespaceURI.length; ++i) {
                    if (!namespaces[i].equals(namespace)) continue;
                    inheritanceIterator.remove();
                }
            }
        }
        return this.inheritanceMultiNames;
    }

    private MultiName getMultiName(String name) {
        MultiName result;
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError((Object)"InheritanceEvaluator.getMultiName(): null name");
        }
        int lastIndex = name.lastIndexOf(":");
        if (lastIndex < 0) {
            lastIndex = name.lastIndexOf(".");
        }
        if (lastIndex > 0) {
            result = new MultiName(new String[]{name.substring(0, lastIndex)}, name.substring(lastIndex + 1));
        } else if (this.qualifiedImports != null && this.qualifiedImports.containsKey(name)) {
            result = new MultiName(new String[]{(String)this.qualifiedImports.get(name)}, name);
        } else if (this.imports != null) {
            String[] namespaces = new String[this.imports.size()];
            this.imports.toArray(namespaces);
            result = new MultiName(namespaces, name);
        } else {
            result = new MultiName(name);
        }
        return result;
    }

    private void processImports(Iterator iterator) {
        while (iterator.hasNext()) {
            Object node = iterator.next();
            if (!(node instanceof ImportDirectiveNode)) continue;
            ImportDirectiveNode importDirective = (ImportDirectiveNode)node;
            if (importDirective.name.id.def_part.length() == 0) {
                this.addImport(importDirective.name.id.pkg_part);
                continue;
            }
            this.addQualifiedImport(importDirective.name.id.def_part, importDirective.name.id.pkg_part);
        }
    }

    private String toString(IdentifierNode identifier) {
        String result = null;
        if (identifier instanceof QualifiedIdentifierNode) {
            QualifiedIdentifierNode qualifiedIdentifier = (QualifiedIdentifierNode)identifier;
            if (qualifiedIdentifier.qualifier instanceof LiteralStringNode) {
                LiteralStringNode literalString = (LiteralStringNode)qualifiedIdentifier.qualifier;
                result = literalString.value + ":" + qualifiedIdentifier.name;
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)("Unhandled QualifiedIdentifierNode qualifier type: " + qualifiedIdentifier.qualifier.getClass().getName()));
            }
        } else {
            result = identifier.name;
        }
        return result;
    }

    static {
        $assertionsDisabled = !InheritanceEvaluator.class.desiredAssertionStatus();
    }
}

