/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.List;

public class FloatArrayList
extends AbstractList
implements List,
Serializable {
    private transient float[] _data = null;
    private int _size = 0;

    public FloatArrayList() {
        this(8);
    }

    public FloatArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity=" + capacity);
        }
        this._data = new float[capacity];
    }

    public int capacity() {
        return this._data.length;
    }

    public int size() {
        return this._size;
    }

    public Object get(int index) {
        this.checkRange(index);
        return new Float(this._data[index]);
    }

    public float getFloat(int index) {
        this.checkRange(index);
        return this._data[index];
    }

    public boolean containsFloat(float value) {
        return -1 != this.indexOfFloat(value);
    }

    public int indexOfFloat(float value) {
        int i = 0;
        while (i < this._size) {
            if (value == this._data[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOfFloat(float value) {
        int i = this._size - 1;
        while (i >= 0) {
            if (value == this._data[i]) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public float setFloat(int index, float value) {
        this.checkRange(index);
        float old = this._data[index];
        this._data[index] = value;
        return old;
    }

    public Object set(int index, Object value) {
        Float f = (Float)value;
        return new Float(this.setFloat(index, f.floatValue()));
    }

    public boolean addFloat(float value) {
        this.ensureCapacity(this._size + 1);
        this._data[this._size++] = value;
        return true;
    }

    public void addFloat(int index, float value) {
        this.checkRangeIncludingEndpoint(index);
        this.ensureCapacity(this._size + 1);
        int numtomove = this._size - index;
        System.arraycopy(this._data, index, this._data, index + 1, numtomove);
        this._data[index] = value;
        ++this._size;
    }

    public void add(int index, Object value) {
        this.addFloat(index, ((Float)value).floatValue());
    }

    public void clear() {
        ++this.modCount;
        this._size = 0;
    }

    public float removeFloatAt(int index) {
        this.checkRange(index);
        ++this.modCount;
        float oldval = this._data[index];
        int numtomove = this._size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this._data, index + 1, this._data, index, numtomove);
        }
        --this._size;
        return oldval;
    }

    public boolean removeFloat(float value) {
        int index = this.indexOfFloat(value);
        if (-1 == index) {
            return false;
        }
        this.removeFloatAt(index);
        return true;
    }

    public Object remove(int index) {
        return new Float(this.removeFloatAt(index));
    }

    public void ensureCapacity(int mincap) {
        ++this.modCount;
        if (mincap > this._data.length) {
            int newcap = this._data.length * 3 / 2 + 1;
            float[] olddata = this._data;
            this._data = new float[newcap < mincap ? mincap : newcap];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        ++this.modCount;
        if (this._size < this._data.length) {
            float[] olddata = this._data;
            this._data = new float[this._size];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._data.length);
        int i = 0;
        while (i < this._size) {
            out.writeFloat(this._data[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._data = new float[in.readInt()];
        int i = 0;
        while (i < this._size) {
            this._data[i] = in.readFloat();
            ++i;
        }
    }

    private final void checkRange(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + index);
        }
    }

    private final void checkRangeIncludingEndpoint(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + index);
        }
    }
}

