/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Line2D;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.PaintServer;
import org.apache.batik.bridge.SVGDecoratedShapeElementBridge;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.events.MutationEvent;

public class SVGLineElementBridge
extends SVGDecoratedShapeElementBridge {
    public String getLocalName() {
        return "line";
    }

    public Bridge getInstance() {
        return new SVGLineElementBridge();
    }

    protected ShapePainter createFillStrokePainter(BridgeContext ctx, Element e, ShapeNode shapeNode) {
        return PaintServer.convertStrokePainter(e, shapeNode, ctx);
    }

    protected void buildShape(BridgeContext ctx, Element e, ShapeNode shapeNode) {
        UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, e);
        String s = e.getAttributeNS(null, "x1");
        float x1 = 0.0f;
        if (s.length() != 0) {
            x1 = UnitProcessor.svgHorizontalCoordinateToUserSpace(s, "x1", uctx);
        }
        s = e.getAttributeNS(null, "y1");
        float y1 = 0.0f;
        if (s.length() != 0) {
            y1 = UnitProcessor.svgVerticalCoordinateToUserSpace(s, "y1", uctx);
        }
        s = e.getAttributeNS(null, "x2");
        float x2 = 0.0f;
        if (s.length() != 0) {
            x2 = UnitProcessor.svgHorizontalCoordinateToUserSpace(s, "x2", uctx);
        }
        s = e.getAttributeNS(null, "y2");
        float y2 = 0.0f;
        if (s.length() != 0) {
            y2 = UnitProcessor.svgVerticalCoordinateToUserSpace(s, "y2", uctx);
        }
        shapeNode.setShape(new Line2D.Float(x1, y1, x2, y2));
    }

    public void handleDOMAttrModifiedEvent(MutationEvent evt) {
        String attrName = evt.getAttrName();
        if (attrName.equals("x1") || attrName.equals("y1") || attrName.equals("x2") || attrName.equals("y2")) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
        } else {
            super.handleDOMAttrModifiedEvent(evt);
        }
    }
}

