/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.experiencecloud.ecid.visitor;

import com.adobe.experiencecloud.ecid.sdid.SupplementalDataIdFactory;
import com.adobe.experiencecloud.ecid.visitor.AmcvCookie;
import com.adobe.experiencecloud.ecid.visitor.AmcvEntry;
import com.adobe.experiencecloud.ecid.visitor.CustomerState;
import com.adobe.experiencecloud.ecid.visitor.VisitorState;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Visitor {
    private static final String AMCV_PREFIX = "AMCV_";
    private String marketingCloudOrgId;
    private SupplementalDataIdFactory supplementalDataIdFactory;
    private VisitorState visitorState;
    private AmcvCookie amcvCookie;
    private String amcvCookieName;

    public Visitor(String marketingCloudOrgId) {
        this(marketingCloudOrgId, null);
    }

    public Visitor(String marketingCloudOrgId, String amcvCookie) {
        this.marketingCloudOrgId = this.normalizeOrgId(marketingCloudOrgId);
        this.visitorState = new VisitorState();
        this.amcvCookie = new AmcvCookie(amcvCookie);
        this.supplementalDataIdFactory = new SupplementalDataIdFactory();
        this.amcvCookieName = AMCV_PREFIX + marketingCloudOrgId;
    }

    public Map<String, AmcvEntry> getVisitorValues() {
        return this.amcvCookie.pickValues(Arrays.asList("MCMID", "MCAAMB", "MCAAMLH"));
    }

    public String getSupplementalDataId(String sdidConsumerID) {
        return this.supplementalDataIdFactory.getSupplementalDataID(sdidConsumerID);
    }

    public void setCustomerIds(Map<String, CustomerState> customerIds) {
        this.visitorState.setCustomerIDs(customerIds);
    }

    public Map<String, VisitorState> getState() {
        this.visitorState.setSdid(this.supplementalDataIdFactory.getState());
        HashMap<String, VisitorState> orgVisitorState = new HashMap<String, VisitorState>();
        orgVisitorState.put(this.marketingCloudOrgId, this.visitorState);
        return orgVisitorState;
    }

    public String getCookieName() {
        return this.amcvCookieName;
    }

    private String normalizeOrgId(String orgId) {
        return !orgId.contains("@") ? orgId + "@AdobeOrg" : orgId;
    }

    public static enum AuthState {
        UNKNOWN,
        AUTHENTICATED,
        LOGGED_OUT;

    }
}

