/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.experiencecloud.ecid.visitor;

import com.adobe.experiencecloud.ecid.visitor.AmcvEntry;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class AmcvCookie {
    private static final Logger LOGGER = Logger.getLogger(AmcvCookie.class.getName());
    private static final String UTF8_ENCODING = "UTF-8";
    private static final String VALUE_SEPARATOR = "-";
    private static final String EXPIRY_IDENTIFIER = "s";
    private static final String TEST_COOKIE = "T";
    private static final String SETTINGS_DIGEST = "settingsDigest";
    private String amcvCookie;
    private Map<String, AmcvEntry> parsedValues;

    public AmcvCookie(String amcvCookie) {
        this.amcvCookie = amcvCookie;
        this.parsedValues = new HashMap<String, AmcvEntry>();
        this.parse();
    }

    public Map<String, AmcvEntry> pickValues(List<String> values) {
        return values.stream().filter(this.parsedValues::containsKey).collect(Collectors.toMap(Function.identity(), this.parsedValues::get));
    }

    private void parse() {
        if (this.amcvCookie == null || this.amcvCookie.equals(TEST_COOKIE)) {
            return;
        }
        try {
            String[] split = URLDecoder.decode(this.amcvCookie, UTF8_ENCODING).split("\\|");
            List<String> amcvValues = Arrays.stream(split).collect(Collectors.toList());
            this.parseSettingsDigest(amcvValues);
            this.parseCookieValues(amcvValues);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.WARNING, "Error occurred while parsing AMCV cookie: " + e.getMessage(), e);
        }
    }

    private void parseCookieValues(List<String> amcvValues) {
        int l = amcvValues.size();
        for (int i = 0; i < l; i += 2) {
            String[] keys = amcvValues.get(i).split(VALUE_SEPARATOR);
            String key = keys[0];
            int expire = 0;
            boolean shouldExpireOnSession = false;
            if (keys.length > 1) {
                if (keys[1].endsWith(EXPIRY_IDENTIFIER)) {
                    shouldExpireOnSession = true;
                    expire = Integer.parseInt(keys[1].substring(0, keys[1].length() - 1));
                } else {
                    expire = Integer.parseInt(keys[1]);
                }
            }
            String value = amcvValues.get(i + 1);
            this.parsedValues.put(key, new AmcvEntry(value, shouldExpireOnSession, expire));
        }
    }

    private void parseSettingsDigest(List<String> amcvValues) {
        if (this.isSettingsDigest(amcvValues.get(0))) {
            this.parsedValues.put(SETTINGS_DIGEST, new AmcvEntry(amcvValues.remove(0), false, 0));
            if (amcvValues.size() % 2 == 1) {
                amcvValues.remove(amcvValues.size() - 1);
            }
        }
    }

    private boolean isSettingsDigest(String firstAmcvToken) {
        return firstAmcvToken.matches("^[\\-0-9]+$");
    }
}

