/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.workflow.HistoryItem;
import com.adobe.cq.testing.client.workflow.InboxItem;
import com.adobe.cq.testing.client.workflow.WorkItem;
import com.adobe.cq.testing.client.workflow.WorkflowEngine;
import com.adobe.cq.testing.client.workflow.WorkflowInstance;
import com.adobe.cq.testing.client.workflow.WorkflowModel;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.JsonUtils;
import org.apache.sling.testing.clients.util.ResourceUtil;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class WorkflowClient
extends CQClient {
    public static final String MANAGE_WF_INSTANCES_PATH = "/etc/workflow/instances";
    public static final String MANAGE_WF_MODELS_PATH = "/etc/workflow/models";
    public static final String MANAGE_WF_INBOX_PATH = "/bin/workflow/inbox";
    public static final String MANAGE_WF_ENGINE_PATH = "/etc/workflow";
    public static final String MODEL_LIST_TYPE_ID = "id";
    public static final String MODEL_LIST_TYPE_URI = "uri";
    public static final String MODEL_DESCR_TYPE_JSON = "JSON";
    public static final String PAYLOAD_TYPE_JCR = "JCR_PATH";
    public static final String PAYLOAD_TYPE_URL = "URL";

    public WorkflowClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public WorkflowClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public String deployModel(String modelSourcePath, String modelType, int ... expectedStatus) throws ClientException, IOException {
        if (modelType == null) {
            modelType = MODEL_DESCR_TYPE_JSON;
        }
        String model = ResourceUtil.readResourceAsString((String)modelSourcePath);
        SlingHttpResponse response = this.doPost(MANAGE_WF_MODELS_PATH, (HttpEntity)FormEntityBuilder.create().addParameter("model", model).addParameter("type", modelType).build(), new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)response, (int[])HttpUtils.getExpectedStatus((int)201, (int[])expectedStatus));
        if (response.getStatusLine().getStatusCode() == 201) {
            String url = response.getHeaders("Location")[0].getValue();
            return this.getPath(url).toString();
        }
        return null;
    }

    public String deployModel(String modelSourcePath, String modelType, List<NameValuePair> replaces, int ... expectedStatus) throws ClientException, IOException {
        if (modelType == null) {
            modelType = MODEL_DESCR_TYPE_JSON;
        }
        String model = ResourceUtil.readResourceAsString((String)modelSourcePath);
        for (NameValuePair replacePair : replaces != null ? replaces : new ArrayList(0)) {
            model = model.replaceAll(replacePair.getName(), replacePair.getValue());
        }
        SlingHttpResponse response = this.doPost(MANAGE_WF_MODELS_PATH, (HttpEntity)FormEntityBuilder.create().addParameter("model", model).addParameter("type", modelType).build(), new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)response, (int[])HttpUtils.getExpectedStatus((int)201, (int[])expectedStatus));
        if (response.getStatusLine().getStatusCode() == 201) {
            String url = response.getHeaders("Location")[0].getValue();
            return this.getPath(url).toString();
        }
        return null;
    }

    public SlingHttpResponse advanceWorkItem(String workItemId, String routeId, int ... expectedStatus) throws ClientException {
        SlingHttpResponse exec = this.doPost(MANAGE_WF_INBOX_PATH, (HttpEntity)FormEntityBuilder.create().addParameter("item", workItemId).addParameter("route", routeId).build(), new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)exec, (int[])HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        return exec;
    }

    public List<SlingHttpResponse> chooseRouteAndAdvance(String workflowInstancePath, int chooseRoute) throws ClientException {
        ArrayList<SlingHttpResponse> responses = new ArrayList<SlingHttpResponse>();
        WorkflowInstance wfInstance = this.getWorkflowInstance(workflowInstancePath, new int[0]);
        List<String> wfWkItemIds = wfInstance.getWorkItemIds();
        for (String wfWkItemId : wfWkItemIds) {
            WorkItem wkItem = this.getWorkItemByURI(wfWkItemId, new int[0]);
            ArrayList<WorkItem.Route> arrayRoutes = wkItem.getRoutes();
            responses.add(this.advanceWorkItem(wkItem.getId(), arrayRoutes.get(chooseRoute).getId(), new int[0]));
        }
        return responses;
    }

    public SlingHttpResponse stepBackWorkItem(String workItemId, String backrouteId, int ... expectedStatus) throws ClientException {
        SlingHttpResponse exec = this.doPost(MANAGE_WF_INBOX_PATH, (HttpEntity)FormEntityBuilder.create().addParameter("item", workItemId).addParameter("backroute", backrouteId).build(), new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)exec, (int[])HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        return exec;
    }

    public SlingHttpResponse delegateWorkItem(String workItemId, String delegatee, int ... expectedStatus) throws ClientException {
        SlingHttpResponse exec = this.doPost(MANAGE_WF_INBOX_PATH, (HttpEntity)FormEntityBuilder.create().addParameter("item", workItemId).addParameter("delegatee", delegatee).build(), new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)exec, (int[])HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        return exec;
    }

    public SlingHttpResponse approveAndAdvanceWorkItem(WorkItem workItem, String routeId, int ... expectedStatus) throws ClientException {
        this.doPost(workItem.getPayLoad(), (HttpEntity)FormEntityBuilder.create().addParameter("item", workItem.getId()).addParameter("route", routeId).addParameter("./approved", "true").addParameter("./approved@Delete", "true").addParameter("./approved@TypeHint", "Boolean").build(), new int[0]);
        SlingHttpResponse exec = this.doPost(MANAGE_WF_INBOX_PATH, (HttpEntity)FormEntityBuilder.create().addParameter("item", workItem.getId()).addParameter("route", routeId).addParameter("./approved", "true").addParameter("./approved@Delete", "true").addParameter("./approved@TypeHint", "Boolean").build(), new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)exec, (int[])HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        return exec;
    }

    public SlingHttpResponse approveComment(String workItemId, String routeId, int ... expectedStatus) throws ClientException {
        SlingHttpResponse exec = this.doPost(MANAGE_WF_INBOX_PATH, (HttpEntity)FormEntityBuilder.create().addParameter("item", workItemId).addParameter("route", routeId).addParameter("./approved", "true").addParameter("./approved@Delete", "true").addParameter("./approved@TypeHint", "Boolean").build(), new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)exec, (int[])HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        return exec;
    }

    public Map<String, InboxItem> getInboxItems(int ... expectedStatus) throws ClientException {
        SlingHttpResponse exec = this.doGet("/bin/workflow/inbox.json", new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)exec, (int[])HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        JsonNode workItems = JsonUtils.getJsonNodeFromString((String)exec.getContent());
        HashMap<String, InboxItem> map = new HashMap<String, InboxItem>();
        for (int i = 0; i < workItems.size(); ++i) {
            JsonNode workItem = workItems.get(i);
            map.put(workItem.get(MODEL_LIST_TYPE_URI).getValueAsText(), new InboxItem(workItem));
        }
        return map;
    }

    public WorkItem getWorkItemByURI(String uri, int ... expectedStatus) throws ClientException {
        SlingHttpResponse exec = this.doGet(uri + ".json", new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)exec, (int[])HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        return new WorkItem(JsonUtils.getJsonNodeFromString((String)exec.getContent()));
    }

    public List<String> getWorkItemBackRouteIds(String uri, int ... expectedStatus) throws ClientException {
        SlingHttpResponse exec = this.doGet(uri + ".backroutes.json", new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)exec, (int[])HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        JsonNode rootNode = JsonUtils.getJsonNodeFromString((String)exec.getContent()).get("backroutes");
        ArrayList<String> backrouteIds = new ArrayList<String>();
        for (int i = 0; i < rootNode.size(); ++i) {
            backrouteIds.add(rootNode.get(i).get("rid").getValueAsText());
        }
        return backrouteIds;
    }

    public SlingHttpResponse deleteModel(String modelId, int ... expectedStatus) throws ClientException {
        String url = modelId + ".json";
        SlingHttpResponse exec = this.doDelete(url, null, null, new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)exec, (int[])HttpUtils.getExpectedStatus((int)204, (int[])expectedStatus));
        return exec;
    }

    public SlingHttpResponse abortWorkflow(String instanceId, int ... expectedStatus) throws ClientException {
        SlingHttpResponse exec = this.doPost(instanceId, (HttpEntity)FormEntityBuilder.create().addParameter("state", "ABORTED").addParameter("terminateComment", "").addParameter("_charset_", "utf-8").build(), new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)exec, (int[])HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        return exec;
    }

    public SlingHttpResponse updateModel(String modelSourcePath, String modelType, String modelId, int ... expectedStatus) throws ClientException, IOException {
        if (modelType == null) {
            modelType = MODEL_DESCR_TYPE_JSON;
        }
        String model = this.getJsonDefinition(modelSourcePath, modelId);
        SlingHttpResponse exec = this.doPost(modelId, (HttpEntity)FormEntityBuilder.create().addParameter("model", model).addParameter("type", modelType).build(), new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)exec, (int[])HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        return exec;
    }

    private String getJsonDefinition(String modelSourcePath, String modelId) throws IOException {
        String model = ResourceUtil.readResourceAsString((String)modelSourcePath);
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = (ObjectNode)mapper.readValue(model, ObjectNode.class);
        node.put(MODEL_LIST_TYPE_ID, modelId);
        return node.toString();
    }

    public WorkflowEngine getWorkflowEngineInfo(int ... expectedStatus) throws ClientException {
        SlingHttpResponse exec = this.doGet("/etc/workflow.json", expectedStatus);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)exec, (int[])HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        JsonNode rootNode = JsonUtils.getJsonNodeFromString((String)exec.getContent());
        HashMap<String, String> properties = new HashMap<String, String>();
        rootNode.getFieldNames();
        Iterator it = rootNode.getFieldNames();
        while (it.hasNext()) {
            String propName = (String)it.next();
            properties.put(propName, rootNode.get(propName).getValueAsText());
        }
        return new WorkflowEngine(properties);
    }

    public SlingHttpResponse stopWorkflowEngine(int ... expectedStatus) throws ClientException {
        SlingHttpResponse exec = this.doPost(MANAGE_WF_ENGINE_PATH, (HttpEntity)FormEntityBuilder.create().addParameter("state", "DISABLED").build(), new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)exec, (int[])HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        return exec;
    }

    public SlingHttpResponse startWorkflowEngine(int ... expectedStatus) throws ClientException {
        SlingHttpResponse exec = this.doPost(MANAGE_WF_ENGINE_PATH, (HttpEntity)FormEntityBuilder.create().addParameter("state", "ACTIVE").build(), new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)exec, (int[])HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        return exec;
    }

    public boolean isWorkflowEngineActive() throws ClientException {
        return "active".equals(this.getWorkflowEngineInfo(new int[0]).getProperty("state").toLowerCase());
    }

    public String startWorkflow(String modelId, String payload, int ... expectedStatus) throws ClientException {
        return this.startWorkflow(modelId, PAYLOAD_TYPE_JCR, payload, null, null, null, expectedStatus);
    }

    public String startWorkflow(String modelId, String payloadType, String payload, Map<String, String> metaData, String title, String comment, int ... expectedStatus) throws ClientException {
        if (modelId == null || "".equals(modelId)) {
            throw new ClientException("Invalid ModelId!");
        }
        if (payload == null || "".equals(payload)) {
            throw new ClientException("No payload set!");
        }
        if (payloadType == null) {
            payloadType = PAYLOAD_TYPE_JCR;
        }
        FormEntityBuilder form = FormEntityBuilder.create();
        form.addParameter("model", modelId);
        form.addParameter("payloadType", payloadType);
        form.addParameter("payload", payload);
        if (title != null && !"".equals(title)) {
            form.addParameter("workflowTitle", title);
        }
        if (comment != null && !"".equals(comment)) {
            form.addParameter("startComment", comment);
        }
        if (metaData != null) {
            for (String key : metaData.keySet()) {
                form.addParameter(key, metaData.get(key));
            }
        }
        SlingHttpResponse response = this.doPost(MANAGE_WF_INSTANCES_PATH, (HttpEntity)form.build(), new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)response, (int[])HttpUtils.getExpectedStatus((int)201, (int[])expectedStatus));
        if (response.getStatusLine().getStatusCode() == 201) {
            return this.getPath(response.getSlingLocation()).toString();
        }
        return null;
    }

    public SlingHttpResponse updateWfInstanceComment(String instanceURI, String comment, int ... expectedStatus) throws ClientException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("startComment", comment);
        return this.updateWfInstanceMetaData(instanceURI, map, expectedStatus);
    }

    public SlingHttpResponse updateWfInstanceTitle(String instanceURI, String title, int ... expectedStatus) throws ClientException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("workflowTitle", title);
        return this.updateWfInstanceMetaData(instanceURI, map, expectedStatus);
    }

    public SlingHttpResponse updateWfInstanceMetaData(String instanceURI, Map<String, String> metaData, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create();
        form.addParameter("action", "UPDATE");
        for (String key : metaData.keySet()) {
            form.addParameter(key, metaData.get(key));
        }
        SlingHttpResponse exec = this.doPost(instanceURI, (HttpEntity)form.build(), new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)exec, (int[])HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        return exec;
    }

    public List<URI> getWorkflowInstanceURLs(Status wfStatus, int ... expectedStatus) throws ClientException {
        String status = "";
        if (wfStatus != null) {
            status = "." + wfStatus.getString();
        }
        SlingHttpResponse exec = this.doGet(MANAGE_WF_INSTANCES_PATH + status + ".json", new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)exec, (int[])HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        JsonNode rootNode = JsonUtils.getJsonNodeFromString((String)exec.getContent());
        ArrayList<URI> wfInstances = new ArrayList<URI>();
        for (JsonNode aRootNode : rootNode) {
            try {
                wfInstances.add(new URI(aRootNode.get(MODEL_LIST_TYPE_URI).getValueAsText()));
            }
            catch (URISyntaxException e) {
                throw new ClientException("Error parsing url: " + aRootNode.get(MODEL_LIST_TYPE_URI).getValueAsText(), (Throwable)e);
            }
        }
        return wfInstances;
    }

    public ArrayList<String> getWorkflowModels(String listType, int ... expectedStatus) throws ClientException {
        if (listType == null) {
            listType = MODEL_LIST_TYPE_URI;
        }
        SlingHttpResponse exec = this.doGet("/etc/workflow/models.json", Collections.singletonList(new BasicNameValuePair("format", listType)), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        JsonNode rootNode = JsonUtils.getJsonNodeFromString((String)exec.getContent());
        ArrayList<String> wfModels = new ArrayList<String>();
        String nodeProperty = MODEL_LIST_TYPE_URI;
        if (listType.equals(MODEL_LIST_TYPE_ID)) {
            nodeProperty = "value";
        }
        for (JsonNode aRootNode : rootNode) {
            wfModels.add(aRootNode.get(nodeProperty).getValueAsText());
        }
        return wfModels;
    }

    public String getWorkflowModelAsJSON(String modelId, String version, int ... expectedStatus) throws ClientException {
        if (version == null || "HEAD".equals(version)) {
            version = "";
        } else {
            Pattern p = Pattern.compile("^\\d+\\.\\d+$");
            Matcher m = p.matcher(version);
            if (!m.find()) {
                throw new IllegalArgumentException("Version identifier " + version + " is invalid!");
            }
            version = "." + version;
        }
        String uri = modelId + version + ".json";
        SlingHttpResponse exec = this.doGet(uri, new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)exec, (int[])HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        return exec.getContent();
    }

    public WorkflowModel getWorkflowModel(String modelId, String version, int ... expectedStatus) throws ClientException {
        return new WorkflowModel(JsonUtils.getJsonNodeFromString((String)this.getWorkflowModelAsJSON(modelId, version, expectedStatus)));
    }

    public WorkflowInstance getWorkflowInstance(String instanceURI, int ... expectedStatus) throws ClientException {
        SlingHttpResponse exec = this.doGet(instanceURI + ".json", new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)exec, (int[])HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        return new WorkflowInstance(JsonUtils.getJsonNodeFromString((String)exec.getContent()));
    }

    public List<WorkflowInstance> getWorkflowInstances(Status wfStatus, String model, String payload, DateTime startTimeLimit, DateTime endTimeLimit) throws ClientException {
        List<URI> urls = this.getWorkflowInstanceURLs(wfStatus, new int[0]);
        ArrayList<WorkflowInstance> workflows = new ArrayList<WorkflowInstance>();
        for (URI url : urls) {
            DateTime wfEnd;
            WorkflowInstance workflowInstance;
            try {
                workflowInstance = this.getWorkflowInstance(this.getPath(url).toString(), new int[0]);
            }
            catch (ClientException e) {
                continue;
            }
            Date start = workflowInstance.getStartTime();
            Date end = workflowInstance.getEndTime();
            DateTime wfStart = null == start ? null : new DateTime((Object)start);
            DateTime dateTime = wfEnd = null == end ? null : new DateTime((Object)end);
            if (model != null && !workflowInstance.getModelId().equals(model) || payload != null && !workflowInstance.getPayload().startsWith(payload) || null != startTimeLimit && null != wfStart && wfStart.isBefore((ReadableInstant)startTimeLimit) || null != endTimeLimit && null != wfEnd && wfEnd.isAfter((ReadableInstant)endTimeLimit)) continue;
            workflows.add(workflowInstance);
        }
        return workflows;
    }

    public List<WorkflowInstance> getWorkflowInstances(Status wfStatus) throws ClientException {
        return this.getWorkflowInstances(wfStatus, null, null, null, null);
    }

    public List<WorkflowInstance> getWorkflowInstances(Status wfStatus, DateTime startTimeLimit, DateTime endTimeLimit) throws ClientException {
        return this.getWorkflowInstances(wfStatus, null, null, startTimeLimit, endTimeLimit);
    }

    public List<WorkflowInstance> getWorkflowInstances() throws ClientException {
        return this.getWorkflowInstances(null);
    }

    public List<HistoryItem> getWorkflowInstanceHistory(String instanceURI, int ... expectedStatus) throws ClientException {
        List<BasicNameValuePair> params = Collections.singletonList(new BasicNameValuePair("workflow", instanceURI));
        SlingHttpResponse exec = this.doGet("/libs/cq/workflow/content/console/history.json", params, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        ArrayList<HistoryItem> listHistoryItems = new ArrayList<HistoryItem>();
        JsonNode workflowHistoryNode = JsonUtils.getJsonNodeFromString((String)exec.getContent());
        JsonNode historyNode = workflowHistoryNode.get("historyItems");
        Iterator historyEntryIterator = historyNode.getElements();
        while (historyEntryIterator.hasNext()) {
            listHistoryItems.add(new HistoryItem((JsonNode)historyEntryIterator.next()));
        }
        return listHistoryItems;
    }

    public SlingHttpResponse setWorkflowInstanceStatus(String instanceURI, Status status, int ... expectedStatus) throws ClientException {
        SlingHttpResponse exec = this.doPost(instanceURI, (HttpEntity)FormEntityBuilder.create().addParameter("state", status.getString()).build(), new int[0]);
        HttpUtils.verifyHttpStatus((SlingHttpResponse)exec, (int[])HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        return exec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseJSONDate(String date) {
        Locale store = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        try {
            Date date2 = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy").parse(date);
            return date2;
        }
        catch (ParseException e) {
            Date date3 = null;
            return date3;
        }
        finally {
            Locale.setDefault(store);
        }
    }

    public static enum Status {
        RUNNING("RUNNING"),
        SUSPENDED("SUSPENDED"),
        ABORTED("ABORTED"),
        COMPLETED("COMPLETED");

        private String status;

        private Status(String status) {
            this.status = status;
        }

        public String getString() {
            return this.status;
        }
    }
}

