/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import java.net.URI;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;

public class MSMClient
extends CQClient {
    public static final String JCR_PRIMARYTYPE = "jcr:primaryType";
    public static final String JCR_CONTENT = "jcr:content";
    public static final String PARAM_SOURCEPATH = "msm:sourcePath";
    public static final String PARAM_IS_DEEP = "msm:isDeep";
    public static final String PN_ROLLOUT_CONFIGS = "cq:rolloutConfigs";
    public static final String LIVECOPY_POST_EXTENSION = ".msm.conf";
    public static final String LIVECOPY_GET_EXTENSION = ".msm.json";
    public static final String BLUEPRINT_POST_EXTENSION = ".blueprint.conf";
    public static final String BLUEPRINT_GET_EXTENSION = ".blueprint.json";
    public static final String PROPERTY_LASTROLLEDOUT = "cq:lastRolledout";
    public static final String PROPERTY_LASTROLLEDOUTBY = "cq:lastRolledoutBy";
    private static final String ROLLOUTCONFIG_FOLDER = "/libs/msm/wcm/rolloutconfigs";
    public static final String ROLLOUTCONFIG_DEFAULT = "/libs/msm/wcm/rolloutconfigs/default";
    public static final String ROLLOUTCONFIG_ACTIVATE = "/libs/msm/wcm/rolloutconfigs/activate";
    public static final String ROLLOUTCONFIG_DEACTIVATE = "/libs/msm/wcm/rolloutconfigs/deactivate";
    public static final String ROLLOUTCONFIG_PUSHONMODIFY = "/libs/msm/wcm/rolloutconfigs/pushonmodify";
    public static final String BLUEPRINT_ROOT = "/libs/msm";
    private static final String RT_ROLLUTCONFIG = "wcm/msm/components/rolloutconfig";
    private static final String NT_LIVE_SNCCONFIG = "cq:LiveSyncAction";
    private static final String PN_TRIGGER = "cq:trigger";

    public MSMClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public MSMClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public SlingHttpResponse createBluePrint(String name, String title, String sitePath, int ... expectedStatus) throws ClientException {
        String blueprintPath = this.createPage(name, title, BLUEPRINT_ROOT, "/libs/wcm/msm/templates/blueprint", expectedStatus).getSlingPath();
        String postPath = blueprintPath + "/jcr:content";
        return this.doPost(postPath, (HttpEntity)FormEntityBuilder.create().addParameter("./sitePath", sitePath).build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse deleteBluePrint(String blueprintPath, int ... expectedStatus) throws ClientException {
        return this.deletePage(new String[]{blueprintPath}, false, false, expectedStatus);
    }

    public SlingHttpResponse createSite(String label, String title, String destPath, boolean isLiveCopy, String[] languages, String[] chapterPaths, String blueprintPath, String[] rolloutConfigs, String siteOwner, int ... expectedStatus) throws ClientException {
        return this.wcmCommands.createSite(label, title, destPath, isLiveCopy, languages, chapterPaths, blueprintPath, rolloutConfigs, siteOwner, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse createLiveCopy(String label, String title, String destPath, String srcPath, boolean shallow, String[] rolloutConfigs, String[] missingPages, boolean excludeSubPages, int ... expectedStatus) throws ClientException {
        return this.wcmCommands.createLiveCopy(label, title, destPath, srcPath, shallow, rolloutConfigs, missingPages, excludeSubPages, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse editRelationship(String target, String sourcePath, boolean deep, String[] rolloutConfigs, int ... expectedStatus) throws ClientException {
        String postPath = target + LIVECOPY_POST_EXTENSION;
        FormEntityBuilder entityBuilder = FormEntityBuilder.create();
        entityBuilder.addParameter(PARAM_SOURCEPATH, sourcePath);
        entityBuilder.addParameter(PARAM_IS_DEEP, Boolean.toString(deep));
        for (String rolloutConfig : rolloutConfigs != null ? rolloutConfigs : new String[]{}) {
            entityBuilder.addParameter(PN_ROLLOUT_CONFIGS, rolloutConfig);
        }
        return this.doPost(postPath, (HttpEntity)entityBuilder.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public String createRolloutConfig(String name, String above, String trigger, String ... liveActions) throws ClientException {
        String path = "/libs/msm/wcm/rolloutconfigs/" + name;
        ArrayList<BasicNameValuePair> props = new ArrayList<BasicNameValuePair>();
        props.add(new BasicNameValuePair(JCR_PRIMARYTYPE, "cq:RolloutConfig"));
        props.add(new BasicNameValuePair(PN_TRIGGER, trigger));
        this.doPost(path, (HttpEntity)FormEntityBuilder.create().addAllParameters(props).build(), new int[]{200, 201});
        if (above != null) {
            UrlEncodedFormEntity entity = FormEntityBuilder.create().addParameter(":order", "before " + above).build();
            this.doPost(path, (HttpEntity)entity, new int[]{200});
        }
        if (liveActions != null) {
            for (String liveAction : liveActions) {
                String liveActionPath = path + "/" + liveAction;
                this.createNode(liveActionPath, NT_LIVE_SNCCONFIG);
            }
        }
        return path;
    }
}

