/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp4;

import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tika.config.Field;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMP;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.mp4.ISO6709Extractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.mp4parser.Box;
import org.mp4parser.Container;
import org.mp4parser.IsoFile;
import org.mp4parser.boxes.apple.AppleAlbumBox;
import org.mp4parser.boxes.apple.AppleArtist2Box;
import org.mp4parser.boxes.apple.AppleArtistBox;
import org.mp4parser.boxes.apple.AppleCommentBox;
import org.mp4parser.boxes.apple.AppleCompilationBox;
import org.mp4parser.boxes.apple.AppleDiskNumberBox;
import org.mp4parser.boxes.apple.AppleEncoderBox;
import org.mp4parser.boxes.apple.AppleGPSCoordinatesBox;
import org.mp4parser.boxes.apple.AppleGenreBox;
import org.mp4parser.boxes.apple.AppleItemListBox;
import org.mp4parser.boxes.apple.AppleNameBox;
import org.mp4parser.boxes.apple.AppleRecordingYear2Box;
import org.mp4parser.boxes.apple.AppleTrackAuthorBox;
import org.mp4parser.boxes.apple.AppleTrackNumberBox;
import org.mp4parser.boxes.apple.Utf8AppleDataBox;
import org.mp4parser.boxes.iso14496.part12.FileTypeBox;
import org.mp4parser.boxes.iso14496.part12.MetaBox;
import org.mp4parser.boxes.iso14496.part12.MovieBox;
import org.mp4parser.boxes.iso14496.part12.MovieHeaderBox;
import org.mp4parser.boxes.iso14496.part12.SampleDescriptionBox;
import org.mp4parser.boxes.iso14496.part12.SampleTableBox;
import org.mp4parser.boxes.iso14496.part12.TrackBox;
import org.mp4parser.boxes.iso14496.part12.TrackHeaderBox;
import org.mp4parser.boxes.iso14496.part12.UserDataBox;
import org.mp4parser.boxes.sampleentry.AudioSampleEntry;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MP4Parser
extends AbstractParser {
    private static final long serialVersionUID = 84011216792285L;
    private static final DecimalFormat DURATION_FORMAT = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ROOT);
    private static final Map<MediaType, List<String>> typesMap;
    private static final Set<MediaType> SUPPORTED_TYPES;
    private ISO6709Extractor iso6709Extractor = new ISO6709Extractor();

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        TemporaryResources tmp = new TemporaryResources();
        TikaInputStream tstream = TikaInputStream.get(stream, tmp);
        try (IsoFile isoFile = new IsoFile(tstream.getFile());){
            FileTypeBox fileType = MP4Parser.getOrNull((Container)isoFile, FileTypeBox.class);
            if (fileType != null) {
                Optional<MediaType> typeHolder = typesMap.entrySet().stream().filter(e -> ((List)e.getValue()).contains(fileType.getMajorBrand())).findFirst().map(Map.Entry::getKey);
                if (!typeHolder.isPresent()) {
                    typeHolder = typesMap.entrySet().stream().filter(e -> ((List)e.getValue()).stream().anyMatch(fileType.getCompatibleBrands()::contains)).findFirst().map(Map.Entry::getKey);
                }
                MediaType type = typeHolder.orElse(MediaType.application("mp4"));
                metadata.set("Content-Type", type.toString());
                if (type.getType().equals("audio")) {
                    metadata.set(XMPDM.AUDIO_COMPRESSOR, fileType.getMajorBrand().trim());
                }
            } else {
                metadata.set("Content-Type", "video/quicktime");
            }
            MovieBox moov = MP4Parser.getOrNull((Container)isoFile, MovieBox.class);
            if (moov == null) {
                return;
            }
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            this.handleMovieHeaderBox(moov, metadata, xhtml);
            this.handleTrackBoxes(moov, metadata, xhtml);
            UserDataBox userData = MP4Parser.getOrNull((Container)moov, UserDataBox.class);
            if (userData != null) {
                this.extractGPS(userData, metadata);
                MetaBox metaBox = MP4Parser.getOrNull((Container)userData, MetaBox.class);
                this.handleApple(metaBox, metadata, xhtml);
            }
            xhtml.endDocument();
        }
        finally {
            tmp.dispose();
        }
    }

    private void handleTrackBoxes(MovieBox moov, Metadata metadata, XHTMLContentHandler xhtml) {
        AudioSampleEntry sample;
        SampleDescriptionBox sampleDesc;
        List tb = moov.getBoxes(TrackBox.class);
        if (tb == null || tb.size() == 0) {
            return;
        }
        TrackBox track = (TrackBox)tb.get(0);
        TrackHeaderBox header = track.getTrackHeaderBox();
        metadata.set(TikaCoreProperties.CREATED, header.getCreationTime());
        metadata.set(TikaCoreProperties.MODIFIED, header.getModificationTime());
        metadata.set(Metadata.IMAGE_WIDTH, (int)header.getWidth());
        metadata.set(Metadata.IMAGE_LENGTH, (int)header.getHeight());
        SampleTableBox samples = track.getSampleTableBox();
        if (samples != null && (sampleDesc = samples.getSampleDescriptionBox()) != null && (sample = MP4Parser.getOrNull((Container)sampleDesc, AudioSampleEntry.class)) != null) {
            XMPDM.ChannelTypePropertyConverter.convertAndSet(metadata, sample.getChannelCount());
            metadata.set(XMPDM.AUDIO_SAMPLE_RATE, (int)sample.getSampleRate());
        }
    }

    private void handleMovieHeaderBox(MovieBox moov, Metadata metadata, XHTMLContentHandler xhtml) {
        MovieHeaderBox mHeader = MP4Parser.getOrNull((Container)moov, MovieHeaderBox.class);
        if (mHeader == null) {
            return;
        }
        metadata.set(TikaCoreProperties.CREATED, mHeader.getCreationTime());
        metadata.set(TikaCoreProperties.MODIFIED, mHeader.getModificationTime());
        double durationSeconds = (double)mHeader.getDuration() / (double)mHeader.getTimescale();
        metadata.set(XMPDM.DURATION, DURATION_FORMAT.format(durationSeconds));
        metadata.set(XMPDM.AUDIO_SAMPLE_RATE, (int)mHeader.getTimescale());
    }

    private void handleApple(MetaBox metaBox, Metadata metadata, XHTMLContentHandler xhtml) throws SAXException {
        AppleCompilationBox compilation;
        AppleDiskNumberBox discNum;
        AppleTrackNumberBox trackNum;
        AppleItemListBox apple = MP4Parser.getOrNull((Container)metaBox, AppleItemListBox.class);
        if (apple == null) {
            return;
        }
        AppleNameBox title = MP4Parser.getOrNull((Container)apple, AppleNameBox.class);
        MP4Parser.addMetadata(TikaCoreProperties.TITLE, metadata, (Utf8AppleDataBox)title);
        AppleArtistBox artist = MP4Parser.getOrNull((Container)apple, AppleArtistBox.class);
        MP4Parser.addMetadata(TikaCoreProperties.CREATOR, metadata, (Utf8AppleDataBox)artist);
        MP4Parser.addMetadata(XMPDM.ARTIST, metadata, (Utf8AppleDataBox)artist);
        AppleArtist2Box artist2 = MP4Parser.getOrNull((Container)apple, AppleArtist2Box.class);
        MP4Parser.addMetadata(XMPDM.ALBUM_ARTIST, metadata, (Utf8AppleDataBox)artist2);
        AppleAlbumBox album = MP4Parser.getOrNull((Container)apple, AppleAlbumBox.class);
        MP4Parser.addMetadata(XMPDM.ALBUM, metadata, (Utf8AppleDataBox)album);
        AppleTrackAuthorBox composer = MP4Parser.getOrNull((Container)apple, AppleTrackAuthorBox.class);
        MP4Parser.addMetadata(XMPDM.COMPOSER, metadata, (Utf8AppleDataBox)composer);
        AppleGenreBox genre = MP4Parser.getOrNull((Container)apple, AppleGenreBox.class);
        MP4Parser.addMetadata(XMPDM.GENRE, metadata, (Utf8AppleDataBox)genre);
        AppleRecordingYear2Box year = MP4Parser.getOrNull((Container)apple, AppleRecordingYear2Box.class);
        if (year != null) {
            metadata.set(XMPDM.RELEASE_DATE, year.getValue());
        }
        if ((trackNum = MP4Parser.getOrNull((Container)apple, AppleTrackNumberBox.class)) != null) {
            metadata.set(XMPDM.TRACK_NUMBER, trackNum.getA());
        }
        if ((discNum = MP4Parser.getOrNull((Container)apple, AppleDiskNumberBox.class)) != null) {
            metadata.set(XMPDM.DISC_NUMBER, discNum.getA());
        }
        if ((compilation = MP4Parser.getOrNull((Container)apple, AppleCompilationBox.class)) != null) {
            metadata.set(XMPDM.COMPILATION, (int)compilation.getValue());
        }
        AppleCommentBox comment = MP4Parser.getOrNull((Container)apple, AppleCommentBox.class);
        MP4Parser.addMetadata(XMPDM.LOG_COMMENT, metadata, (Utf8AppleDataBox)comment);
        AppleEncoderBox encoder = MP4Parser.getOrNull((Container)apple, AppleEncoderBox.class);
        if (encoder != null) {
            metadata.set(XMP.CREATOR_TOOL, encoder.getValue());
        }
        for (Box box : apple.getBoxes()) {
            if (!(box instanceof Utf8AppleDataBox)) continue;
            xhtml.element("p", ((Utf8AppleDataBox)box).getValue());
        }
    }

    @Field
    public void setMaxRecordSize(long maxRecordSize) {
        IsoFile.MAX_RECORD_SIZE_OVERRIDE = maxRecordSize;
    }

    private void extractGPS(UserDataBox userData, Metadata metadata) {
        AppleGPSCoordinatesBox coordBox = MP4Parser.getOrNull((Container)userData, AppleGPSCoordinatesBox.class);
        if (coordBox == null) {
            return;
        }
        String iso6709 = coordBox.getValue();
        this.iso6709Extractor.extract(iso6709, metadata);
    }

    private static void addMetadata(Property prop, Metadata m, Utf8AppleDataBox metadata) {
        if (metadata != null) {
            m.set(prop, metadata.getValue());
        }
    }

    private static <T extends Box> T getOrNull(Container box, Class<T> clazz) {
        if (box == null) {
            return null;
        }
        List boxes = box.getBoxes(clazz);
        if (boxes.size() == 0) {
            return null;
        }
        return (T)((Box)boxes.get(0));
    }

    static {
        DURATION_FORMAT.applyPattern("0.0#");
        typesMap = new HashMap<MediaType, List<String>>();
        typesMap.put(MediaType.audio("mp4"), Arrays.asList("M4A ", "M4B ", "F4A ", "F4B "));
        typesMap.put(MediaType.video("3gpp"), Arrays.asList("3ge6", "3ge7", "3gg6", "3gp1", "3gp2", "3gp3", "3gp4", "3gp5", "3gp6", "3gs7"));
        typesMap.put(MediaType.video("3gpp2"), Arrays.asList("3g2a", "3g2b", "3g2c"));
        typesMap.put(MediaType.video("mp4"), Arrays.asList("mp41", "mp42"));
        typesMap.put(MediaType.video("x-m4v"), Arrays.asList("M4V ", "M4VH", "M4VP"));
        typesMap.put(MediaType.video("quicktime"), Collections.emptyList());
        typesMap.put(MediaType.application("mp4"), Collections.emptyList());
        SUPPORTED_TYPES = Collections.unmodifiableSet(typesMap.keySet());
    }
}

