/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.sling.commons.osgi.ManifestHeader;
import org.apache.sling.jcr.contentloader.ImportOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathEntry
extends ImportOptions {
    private static final Logger log = LoggerFactory.getLogger(PathEntry.class);
    public static final String CONTENT_HEADER = "Sling-Initial-Content";
    public static final String OVERWRITE_DIRECTIVE = "overwrite";
    public static final String OVERWRITE_PROPERTIES_DIRECTIVE = "overwriteProperties";
    public static final String MERGE_PROPERTIES_DIRECTIVE = "mergeProperties";
    public static final String MERGE_NODES_DIRECTIVE = "merge";
    public static final String UNINSTALL_DIRECTIVE = "uninstall";
    public static final String PATH_DIRECTIVE = "path";
    public static final String WORKSPACE_DIRECTIVE = "workspace";
    public static final String CHECKIN_DIRECTIVE = "checkin";
    public static final String AUTOCHECKOUT_DIRECTIVE = "autoCheckout";
    public static final String IGNORE_CONTENT_READERS_DIRECTIVE = "ignoreImportProviders";
    public static final String REQUIRE_CONTENT_READERS_DIRECTIVE = "requireImportProviders";
    private static final String MAVEN_MOUNT_DIRECTIVE = "maven:mount";
    public Set<String> VALID_DIRECTIVES = new HashSet<String>(Arrays.asList("overwrite", "overwriteProperties", "mergeProperties", "merge", "uninstall", "path", "workspace", "checkin", "autoCheckout", "ignoreImportProviders", "requireImportProviders", "maven:mount"));
    private final boolean propertyMerge;
    private final boolean nodeMerge;
    private final String path;
    private final boolean overwrite;
    private final boolean overwriteProperties;
    private final boolean uninstall;
    private final boolean checkin;
    private final boolean autoCheckout;
    private final List<String> ignoreContentReaders;
    private final List<String> requireContentReaders;
    private final String target;
    private final String workspace;
    private long lastModified;

    @Nullable
    public static Iterator<PathEntry> getContentPaths(@NotNull Manifest manifest, long bundleLastModified) {
        Map<String, String> headers = manifest.getMainAttributes().entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
        return PathEntry.getContentPaths(headers, bundleLastModified);
    }

    @Nullable
    public static Iterator<PathEntry> getContentPaths(Bundle bundle) {
        return PathEntry.getContentPaths(PathEntry.toMap(bundle.getHeaders()), bundle.getLastModified(), bundle.getSymbolicName());
    }

    @Nullable
    public static Iterator<PathEntry> getContentPaths(Map<String, String> headers, long bundleLastModified) {
        return PathEntry.getContentPaths(headers, bundleLastModified, null);
    }

    @Nullable
    private static Iterator<PathEntry> getContentPaths(Map<String, String> headers, long bundleLastModified, @Nullable String bundleSymblicName) {
        String root;
        ArrayList<PathEntry> entries = new ArrayList<PathEntry>();
        String bundleLastModifiedStamp = headers.get("Bnd-LastModified");
        if (bundleLastModifiedStamp != null) {
            bundleLastModified = Math.min(bundleLastModified, Long.parseLong(bundleLastModifiedStamp));
        }
        if ((root = headers.get(CONTENT_HEADER)) != null) {
            ManifestHeader header = ManifestHeader.parse(root);
            for (ManifestHeader.Entry entry : header.getEntries()) {
                entries.add(new PathEntry(entry, bundleLastModified, bundleSymblicName));
            }
        }
        if (entries.isEmpty()) {
            return null;
        }
        return entries.iterator();
    }

    private static Map<String, String> toMap(Dictionary<String, String> dict) {
        ArrayList<String> keys = Collections.list(dict.keys());
        return keys.stream().collect(Collectors.toMap(Function.identity(), dict::get));
    }

    public PathEntry(ManifestHeader.Entry entry, long bundleLastModified) {
        this(entry, bundleLastModified, null);
    }

    public PathEntry(ManifestHeader.Entry entry, long bundleLastModified, @Nullable String bundleSymbolicName) {
        this.path = entry.getValue();
        this.lastModified = bundleLastModified;
        String logPrefix = bundleSymbolicName != null && !bundleSymbolicName.isEmpty() ? "Bundle '" + bundleSymbolicName + "': " : "";
        if (entry.getAttributes().length > 0) {
            log.warn("{}Attributes are not supported in header {} but this header used attributes '{}'. Maybe a directive (with key/value separator ':=') was meant instead?", logPrefix, CONTENT_HEADER, Arrays.stream(entry.getAttributes()).map(attr -> attr.getName() + "=" + attr.getValue()).collect(Collectors.joining(", ")));
        }
        for (ManifestHeader.NameValuePair directive : entry.getDirectives()) {
            if (this.VALID_DIRECTIVES.contains(directive.getName())) continue;
            log.warn("{}Directive '{}' not supported in header {} but it is used with value '{}'", logPrefix, directive.getName(), CONTENT_HEADER, directive.getValue());
        }
        String mergeProperties = entry.getDirectiveValue(MERGE_PROPERTIES_DIRECTIVE);
        this.propertyMerge = mergeProperties != null ? Boolean.valueOf(mergeProperties) : false;
        String mergeNodes = entry.getDirectiveValue(MERGE_NODES_DIRECTIVE);
        this.nodeMerge = mergeNodes != null ? Boolean.valueOf(mergeProperties) : false;
        String overwriteValue = entry.getDirectiveValue(OVERWRITE_DIRECTIVE);
        this.overwrite = overwriteValue != null ? Boolean.valueOf(overwriteValue) : false;
        String overwritePropertiesValue = entry.getDirectiveValue(OVERWRITE_PROPERTIES_DIRECTIVE);
        this.overwriteProperties = overwritePropertiesValue != null ? Boolean.valueOf(overwritePropertiesValue) : false;
        String uninstallValue = entry.getDirectiveValue(UNINSTALL_DIRECTIVE);
        this.uninstall = uninstallValue != null ? Boolean.valueOf(uninstallValue) : this.overwrite;
        String pathValue = entry.getDirectiveValue(PATH_DIRECTIVE);
        this.target = pathValue != null ? pathValue : null;
        String checkinValue = entry.getDirectiveValue(CHECKIN_DIRECTIVE);
        this.checkin = checkinValue != null ? Boolean.valueOf(checkinValue) : false;
        String autoCheckoutValue = entry.getDirectiveValue(AUTOCHECKOUT_DIRECTIVE);
        this.autoCheckout = autoCheckoutValue != null ? Boolean.valueOf(autoCheckoutValue) : true;
        this.ignoreContentReaders = new ArrayList<String>();
        String expandValue = entry.getDirectiveValue(IGNORE_CONTENT_READERS_DIRECTIVE);
        if (expandValue != null && expandValue.length() > 0) {
            StringTokenizer st = new StringTokenizer(expandValue, ",");
            while (st.hasMoreTokens()) {
                this.ignoreContentReaders.add(st.nextToken());
            }
        }
        this.requireContentReaders = new ArrayList<String>();
        String requireContentReadersValue = entry.getDirectiveValue(REQUIRE_CONTENT_READERS_DIRECTIVE);
        if (requireContentReadersValue != null && requireContentReadersValue.length() > 0) {
            StringTokenizer st = new StringTokenizer(requireContentReadersValue, ",");
            while (st.hasMoreTokens()) {
                this.requireContentReaders.add(st.nextToken());
            }
        }
        String workspaceValue = entry.getDirectiveValue(WORKSPACE_DIRECTIVE);
        this.workspace = pathValue != null ? workspaceValue : null;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public boolean isOverwrite() {
        return this.overwrite;
    }

    @Override
    public boolean isPropertyOverwrite() {
        return this.overwriteProperties;
    }

    public boolean isUninstall() {
        return this.uninstall;
    }

    @Override
    public boolean isCheckin() {
        return this.checkin;
    }

    @Override
    public boolean isAutoCheckout() {
        return this.autoCheckout;
    }

    @Override
    public boolean isIgnoredImportProvider(String extension) {
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        return this.ignoreContentReaders.contains(extension);
    }

    public Set<String> getIgnoredContentReaders() {
        return new HashSet<String>(this.ignoreContentReaders);
    }

    @Override
    public boolean isImportProviderRequired(@NotNull String name) {
        boolean required = false;
        if (!this.requireContentReaders.isEmpty()) {
            required = this.requireContentReaders.stream().anyMatch(suffix -> this.hasNameSuffix(name, (String)suffix) && !this.isIgnoredImportProvider((String)suffix));
        }
        return required;
    }

    private boolean hasNameSuffix(String name, String suffix) {
        return name != null && suffix != null && name.length() > suffix.length() && name.endsWith(suffix) && '.' == name.charAt(name.length() - suffix.length() - 1);
    }

    public String getTarget() {
        return this.target;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    @Override
    public boolean isPropertyMerge() {
        return this.propertyMerge;
    }

    @Override
    public boolean isMerge() {
        return this.nodeMerge;
    }
}

