/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.auth.spi;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated(since="2015")
public class AuthenticationInfo
extends HashMap<String, Object> {
    public static final AuthenticationInfo DOING_AUTH = new ReadOnlyAuthenticationInfo("DOING_AUTH");
    public static final AuthenticationInfo FAIL_AUTH = new ReadOnlyAuthenticationInfo("FAIL_AUTH");
    public static final String AUTH_TYPE = "sling.authType";
    public static final String USER = "user.name";
    public static final String PASSWORD = "user.password";
    public static final String CREDENTIALS = "user.jcr.credentials";

    public AuthenticationInfo(String authType) {
        this(authType, null, null);
    }

    public AuthenticationInfo(String authType, String userId) {
        this(authType, userId, null);
    }

    public AuthenticationInfo(String authType, String userId, char[] password) {
        super.put(AUTH_TYPE, authType);
        this.putIfNotNull(USER, userId);
        this.putIfNotNull(PASSWORD, password);
    }

    public final void setAuthType(String authType) {
        this.putIfNotNull(AUTH_TYPE, authType);
    }

    public final String getAuthType() {
        return (String)this.get(AUTH_TYPE);
    }

    public final void setUser(String user) {
        this.putIfNotNull(USER, user);
    }

    public final String getUser() {
        return (String)this.get(USER);
    }

    public final void setPassword(char[] password) {
        this.putIfNotNull(PASSWORD, password);
    }

    public final char[] getPassword() {
        return (char[])this.get(PASSWORD);
    }

    @Override
    public Object put(String key, Object value) {
        if (AUTH_TYPE.equals(key) && !(value instanceof String)) {
            throw new IllegalArgumentException("sling.authType property must be a String");
        }
        if (USER.equals(key) && !(value instanceof String)) {
            throw new IllegalArgumentException("user.name property must be a String");
        }
        if (PASSWORD.equals(key) && !(value instanceof char[])) {
            throw new IllegalArgumentException("user.password property must be a char[]");
        }
        if (CREDENTIALS.equals(key) && !this.isCredentialsObject(value)) {
            throw new IllegalArgumentException("user.jcr.credentials property must be a javax.jcr.Credentials instance");
        }
        return super.put(key, value);
    }

    private boolean isCredentialsObject(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> checkClass = value.getClass();
        do {
            Class<?>[] interfaces;
            for (Class<?> current : interfaces = value.getClass().getInterfaces()) {
                if (!current.getName().equals("javax.jcr.Credentials")) continue;
                return true;
            }
        } while ((checkClass = checkClass.getSuperclass()) != null);
        return false;
    }

    @Override
    public Object remove(Object key) {
        if (AUTH_TYPE.equals(key)) {
            return null;
        }
        return super.remove(key);
    }

    @Override
    public void clear() {
        String authType = this.getAuthType();
        super.clear();
        this.setAuthType(authType);
    }

    private void putIfNotNull(String key, Object value) {
        if (value != null) {
            this.put(key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated(since="2015")
    private static final class ReadOnlyAuthenticationInfo
    extends AuthenticationInfo {
        ReadOnlyAuthenticationInfo(String authType) {
            super(authType);
        }

        @Override
        public Object put(String key, Object value) {
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
        }

        @Override
        public void clear() {
        }

        @Override
        public Object remove(Object key) {
            return null;
        }
    }
}

