/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.auth.core.AuthUtil;

public abstract class AbstractAuthenticationFormServlet
extends HttpServlet {
    public static final String DEFAULT_FORM_PATH = "login.html";
    public static final String CUSTOM_FORM_PATH = "custom_login.html";
    private final AtomicReference<String> rawForm = new AtomicReference();

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.handle(request, response);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.handle(request, response);
    }

    private void handle(HttpServletRequest request, HttpServletResponse response) {
        try {
            response.reset();
            response.setContentType("text/html");
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Cache-Control", "no-cache");
            response.addHeader("Cache-Control", "no-store");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "0");
            response.getWriter().print(this.getForm(request));
            response.flushBuffer();
        }
        catch (IOException ioe) {
            this.log("Unexpected exception caught", ioe);
            try {
                response.sendError(500);
            }
            catch (IOException ioe2) {
                this.log("Unexpected exception caught while sending the error", ioe2);
            }
        }
    }

    protected String getForm(HttpServletRequest request) throws IOException {
        String form = this.getRawForm();
        String resource = AbstractAuthenticationFormServlet.cleanse(request, this.getResource(request));
        String reason = this.getReason(request);
        String resourceContextPath = AbstractAuthenticationFormServlet.cleanse(request, this.getContextPath(request));
        String contextPath = request.getContextPath();
        form = form.replace("${resource}", AbstractAuthenticationFormServlet.escape(resource));
        form = form.replace("${j_reason}", AbstractAuthenticationFormServlet.escape(reason));
        form = form.replace("${requestContextPath}", AbstractAuthenticationFormServlet.escape(resourceContextPath));
        form = form.replace("${contextPath}", AbstractAuthenticationFormServlet.escape(contextPath));
        return form;
    }

    private static String cleanse(HttpServletRequest request, String target) {
        if (target.length() > 0 && !AuthUtil.isRedirectValid(request, target)) {
            return "";
        }
        return target;
    }

    private static String escape(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '&') {
                b.append("&amp;");
                continue;
            }
            if (c == '<') {
                b.append("&lt;");
                continue;
            }
            if (c == '>') {
                b.append("&gt;");
                continue;
            }
            if (c == '\"') {
                b.append("%22");
                continue;
            }
            if (c == '\'') {
                b.append("%27");
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    protected String getResource(HttpServletRequest request) {
        return AuthUtil.getLoginResource(request, "");
    }

    protected abstract String getReason(HttpServletRequest var1);

    protected String getContextPath(HttpServletRequest request) {
        int query;
        String contextPath = this.getResource(request);
        if ("".equals(contextPath)) {
            contextPath = request.getContextPath();
        }
        if ((query = contextPath.indexOf(63)) > 0) {
            contextPath = contextPath.substring(0, query);
        }
        return AbstractAuthenticationFormServlet.removeEndingSlash(contextPath);
    }

    private static String removeEndingSlash(String str) {
        if (str != null && str.endsWith("/")) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    private String getRawForm() throws IOException {
        String value = this.rawForm.get();
        if (value == null) {
            try (InputStream ins = this.getLoginFormStream();
                 InputStreamReader r = ins == null ? null : new InputStreamReader(ins, StandardCharsets.UTF_8);){
                if (r != null) {
                    StringBuilder builder = new StringBuilder();
                    char[] cbuf = new char[1024];
                    int rd = 0;
                    while ((rd = r.read(cbuf)) >= 0) {
                        builder.append(cbuf, 0, rd);
                    }
                    value = builder.toString();
                    this.rawForm.set(value);
                }
            }
            if (value == null) {
                throw new IOException("Failed reading form template");
            }
        }
        return value;
    }

    private InputStream getLoginFormStream() {
        InputStream ins = this.getClass().getResourceAsStream(this.getCustomFormPath());
        if (ins == null) {
            ins = this.getClass().getResourceAsStream(this.getDefaultFormPath());
        }
        return ins;
    }

    protected String getDefaultFormPath() {
        return DEFAULT_FORM_PATH;
    }

    protected String getCustomFormPath() {
        return CUSTOM_FORM_PATH;
    }
}

