/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.commons.json;

import java.util.Map;
import org.apache.oltu.commons.json.CustomizableEntity;
import org.json.JSONStringer;

public abstract class CustomizableEntityWriter<CE extends CustomizableEntity> {
    private final JSONStringer jsonWriter = new JSONStringer();

    public final String write(CE customizableEntity) {
        this.jsonWriter.object();
        this.handleProperties(customizableEntity);
        for (Map.Entry<String, Object> customFields : ((CustomizableEntity)customizableEntity).getCustomFields()) {
            this.set(customFields.getKey(), customFields.getValue());
        }
        this.jsonWriter.endObject();
        return this.jsonWriter.toString();
    }

    protected abstract void handleProperties(CE var1);

    protected final <T> void set(String key, T value) {
        if (value != null) {
            this.jsonWriter.key(key).value(value);
        }
    }

    protected final <T> void set(String key, T[] value) {
        if (value == null) {
            return;
        }
        this.jsonWriter.key(key).array();
        for (T item : value) {
            if (item == null) continue;
            this.jsonWriter.value(item);
        }
        this.jsonWriter.endArray();
    }
}

