/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene45;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.MathUtil;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.packed.BlockPackedWriter;
import org.apache.lucene.util.packed.MonotonicBlockPackedWriter;
import org.apache.lucene.util.packed.PackedInts;

public class Lucene45DocValuesConsumer
extends DocValuesConsumer
implements Closeable {
    static final int BLOCK_SIZE = 16384;
    static final int ADDRESS_INTERVAL = 16;
    static final Number MISSING_ORD = -1L;
    public static final int DELTA_COMPRESSED = 0;
    public static final int GCD_COMPRESSED = 1;
    public static final int TABLE_COMPRESSED = 2;
    public static final int BINARY_FIXED_UNCOMPRESSED = 0;
    public static final int BINARY_VARIABLE_UNCOMPRESSED = 1;
    public static final int BINARY_PREFIX_COMPRESSED = 2;
    public static final int SORTED_SET_WITH_ADDRESSES = 0;
    public static final int SORTED_SET_SINGLE_VALUED_SORTED = 1;
    final IndexOutput data;
    final IndexOutput meta;
    final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene45DocValuesConsumer(SegmentWriteState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        boolean success = false;
        try {
            String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
            this.data = state.directory.createOutput(dataName, state.context);
            CodecUtil.writeHeader(this.data, dataCodec, 1);
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            this.meta = state.directory.createOutput(metaName, state.context);
            CodecUtil.writeHeader(this.meta, metaCodec, 1);
            this.maxDoc = state.segmentInfo.getDocCount();
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public void addNumericField(FieldInfo field, Iterable<Number> values) throws IOException {
        this.addNumericField(field, values, true);
    }

    void addNumericField(FieldInfo field, Iterable<Number> values, boolean optimizeStorage) throws IOException {
        long count = 0L;
        long minValue = Long.MAX_VALUE;
        long maxValue = Long.MIN_VALUE;
        long gcd = 0L;
        boolean missing = false;
        HashSet<Long> uniqueValues = null;
        if (optimizeStorage) {
            uniqueValues = new HashSet<Long>();
            for (Number nv : values) {
                long v;
                if (nv == null) {
                    v = 0L;
                    missing = true;
                } else {
                    v = nv.longValue();
                }
                if (gcd != 1L) {
                    if (v < -4611686018427387904L || v > 0x3FFFFFFFFFFFFFFFL) {
                        gcd = 1L;
                    } else if (count != 0L) {
                        gcd = MathUtil.gcd(gcd, v - minValue);
                    }
                }
                minValue = Math.min(minValue, v);
                maxValue = Math.max(maxValue, v);
                if (uniqueValues != null && uniqueValues.add(v) && uniqueValues.size() > 256) {
                    uniqueValues = null;
                }
                ++count;
            }
        } else {
            for (Number nv : values) {
                ++count;
            }
        }
        long delta = maxValue - minValue;
        int format = uniqueValues != null && (delta < 0L || PackedInts.bitsRequired(uniqueValues.size() - 1) < PackedInts.bitsRequired(delta)) && count <= Integer.MAX_VALUE ? 2 : (gcd != 0L && gcd != 1L ? 1 : 0);
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)0);
        this.meta.writeVInt(format);
        if (missing) {
            this.meta.writeLong(this.data.getFilePointer());
            this.writeMissingBitset(values);
        } else {
            this.meta.writeLong(-1L);
        }
        this.meta.writeVInt(1);
        this.meta.writeLong(this.data.getFilePointer());
        this.meta.writeVLong(count);
        this.meta.writeVInt(16384);
        switch (format) {
            case 1: {
                this.meta.writeLong(minValue);
                this.meta.writeLong(gcd);
                BlockPackedWriter quotientWriter = new BlockPackedWriter(this.data, 16384);
                for (Number nv : values) {
                    long value = nv == null ? 0L : nv.longValue();
                    quotientWriter.add((value - minValue) / gcd);
                }
                quotientWriter.finish();
                break;
            }
            case 0: {
                BlockPackedWriter writer = new BlockPackedWriter(this.data, 16384);
                for (Number nv : values) {
                    writer.add(nv == null ? 0L : nv.longValue());
                }
                writer.finish();
                break;
            }
            case 2: {
                Long[] decode = uniqueValues.toArray(new Long[uniqueValues.size()]);
                HashMap<Long, Integer> encode = new HashMap<Long, Integer>();
                this.meta.writeVInt(decode.length);
                for (int i = 0; i < decode.length; ++i) {
                    this.meta.writeLong(decode[i]);
                    encode.put(decode[i], i);
                }
                int bitsRequired = PackedInts.bitsRequired(uniqueValues.size() - 1);
                PackedInts.Writer ordsWriter = PackedInts.getWriterNoHeader(this.data, PackedInts.Format.PACKED, (int)count, bitsRequired, 1024);
                for (Number nv : values) {
                    ordsWriter.add(((Integer)encode.get(nv == null ? 0L : nv.longValue())).intValue());
                }
                ordsWriter.finish();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    void writeMissingBitset(Iterable<?> values) throws IOException {
        byte bits = 0;
        int count = 0;
        for (Object v : values) {
            if (count == 8) {
                this.data.writeByte(bits);
                count = 0;
                bits = 0;
            }
            if (v != null) {
                bits = (byte)(bits | 1 << (count & 7));
            }
            ++count;
        }
        if (count > 0) {
            this.data.writeByte(bits);
        }
    }

    @Override
    public void addBinaryField(FieldInfo field, Iterable<BytesRef> values) throws IOException {
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)1);
        int minLength = Integer.MAX_VALUE;
        int maxLength = Integer.MIN_VALUE;
        long startFP = this.data.getFilePointer();
        long count = 0L;
        boolean missing = false;
        for (BytesRef v : values) {
            int length;
            if (v == null) {
                length = 0;
                missing = true;
            } else {
                length = v.length;
            }
            minLength = Math.min(minLength, length);
            maxLength = Math.max(maxLength, length);
            if (v != null) {
                this.data.writeBytes(v.bytes, v.offset, v.length);
            }
            ++count;
        }
        this.meta.writeVInt(minLength == maxLength ? 0 : 1);
        if (missing) {
            this.meta.writeLong(this.data.getFilePointer());
            this.writeMissingBitset(values);
        } else {
            this.meta.writeLong(-1L);
        }
        this.meta.writeVInt(minLength);
        this.meta.writeVInt(maxLength);
        this.meta.writeVLong(count);
        this.meta.writeLong(startFP);
        if (minLength != maxLength) {
            this.meta.writeLong(this.data.getFilePointer());
            this.meta.writeVInt(1);
            this.meta.writeVInt(16384);
            MonotonicBlockPackedWriter writer = new MonotonicBlockPackedWriter(this.data, 16384);
            long addr = 0L;
            for (BytesRef v : values) {
                if (v != null) {
                    addr += (long)v.length;
                }
                writer.add(addr);
            }
            writer.finish();
        }
    }

    protected void addTermsDict(FieldInfo field, Iterable<BytesRef> values) throws IOException {
        int minLength = Integer.MAX_VALUE;
        int maxLength = Integer.MIN_VALUE;
        for (BytesRef v : values) {
            minLength = Math.min(minLength, v.length);
            maxLength = Math.max(maxLength, v.length);
        }
        if (minLength == maxLength) {
            this.addBinaryField(field, values);
        } else {
            this.meta.writeVInt(field.number);
            this.meta.writeByte((byte)1);
            this.meta.writeVInt(2);
            this.meta.writeLong(-1L);
            long startFP = this.data.getFilePointer();
            RAMOutputStream addressBuffer = new RAMOutputStream();
            MonotonicBlockPackedWriter termAddresses = new MonotonicBlockPackedWriter(addressBuffer, 16384);
            BytesRef lastTerm = new BytesRef();
            long count = 0L;
            for (BytesRef v : values) {
                if (count % 16L == 0L) {
                    termAddresses.add(this.data.getFilePointer() - startFP);
                    lastTerm.length = 0;
                }
                int sharedPrefix = StringHelper.bytesDifference(lastTerm, v);
                this.data.writeVInt(sharedPrefix);
                this.data.writeVInt(v.length - sharedPrefix);
                this.data.writeBytes(v.bytes, v.offset + sharedPrefix, v.length - sharedPrefix);
                lastTerm.copyBytes(v);
                ++count;
            }
            long indexStartFP = this.data.getFilePointer();
            termAddresses.finish();
            addressBuffer.writeTo(this.data);
            addressBuffer = null;
            termAddresses = null;
            this.meta.writeVInt(minLength);
            this.meta.writeVInt(maxLength);
            this.meta.writeVLong(count);
            this.meta.writeLong(startFP);
            this.meta.writeVInt(16);
            this.meta.writeLong(indexStartFP);
            this.meta.writeVInt(1);
            this.meta.writeVInt(16384);
        }
    }

    @Override
    public void addSortedField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrd) throws IOException {
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)2);
        this.addTermsDict(field, values);
        this.addNumericField(field, docToOrd, false);
    }

    private static boolean isSingleValued(Iterable<Number> docToOrdCount) {
        for (Number ordCount : docToOrdCount) {
            if (ordCount.longValue() <= 1L) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addSortedSetField(FieldInfo field, Iterable<BytesRef> values, final Iterable<Number> docToOrdCount, final Iterable<Number> ords) throws IOException {
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)3);
        if (Lucene45DocValuesConsumer.isSingleValued(docToOrdCount)) {
            this.meta.writeVInt(1);
            this.addSortedField(field, values, new Iterable<Number>(){

                @Override
                public Iterator<Number> iterator() {
                    final Iterator docToOrdCountIt = docToOrdCount.iterator();
                    final Iterator ordsIt = ords.iterator();
                    return new Iterator<Number>(){

                        @Override
                        public boolean hasNext() {
                            assert (!ordsIt.hasNext() || docToOrdCountIt.hasNext());
                            return docToOrdCountIt.hasNext();
                        }

                        @Override
                        public Number next() {
                            Number ordCount = (Number)docToOrdCountIt.next();
                            if (ordCount.longValue() == 0L) {
                                return MISSING_ORD;
                            }
                            assert (ordCount.longValue() == 1L);
                            return (Number)ordsIt.next();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            });
            return;
        }
        this.meta.writeVInt(0);
        this.addTermsDict(field, values);
        this.addNumericField(field, ords, false);
        this.meta.writeVInt(field.number);
        this.meta.writeByte((byte)0);
        this.meta.writeVInt(0);
        this.meta.writeLong(-1L);
        this.meta.writeVInt(1);
        this.meta.writeLong(this.data.getFilePointer());
        this.meta.writeVLong(this.maxDoc);
        this.meta.writeVInt(16384);
        MonotonicBlockPackedWriter writer = new MonotonicBlockPackedWriter(this.data, 16384);
        long addr = 0L;
        for (Number v : docToOrdCount) {
            writer.add(addr += v.longValue());
        }
        writer.finish();
    }

    @Override
    public void close() throws IOException {
        block6: {
            block5: {
                boolean success = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeVInt(-1);
                    }
                    if (!(success = true)) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(this.data, this.meta);
                    } else {
                        IOUtils.closeWhileHandlingException(this.data, this.meta);
                    }
                    throw throwable;
                }
                IOUtils.close(this.data, this.meta);
                break block6;
            }
            IOUtils.closeWhileHandlingException(this.data, this.meta);
        }
    }
}

