/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageManager;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageDefinitionImpl;
import org.apache.jackrabbit.vault.packaging.impl.JcrPackageManagerImpl;
import org.apache.jackrabbit.vault.packaging.impl.PackageManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackagingService {
    private static final Logger log = LoggerFactory.getLogger(PackagingService.class);

    public static PackageManager getPackageManager() {
        return new PackageManagerImpl();
    }

    public static JcrPackageManager getPackageManager(Session session) {
        try {
            throw new IllegalStateException();
        }
        catch (IllegalStateException e) {
            log.info("JcrPackageManager acquired w/o service! Alternate package roots will not be respected.", e);
            return new JcrPackageManagerImpl(session, new String[0]);
        }
    }

    public static JcrPackageDefinition createPackageDefinition(Node defNode) {
        return new JcrPackageDefinitionImpl(defNode);
    }

    public static JcrPackage open(Node node, boolean allowInvalid) throws RepositoryException {
        JcrPackageManager pMgr = PackagingService.getPackageManager(node.getSession());
        return pMgr.open(node, allowInvalid);
    }
}

